/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.criteria;

import java.util.HashMap;
import org.apache.avalon.util.criteria.CriteriaRuntimeException;
import org.apache.avalon.util.criteria.Parameter;

public class Criteria
extends HashMap {
    private final Parameter[] m_params;

    public Criteria(Parameter[] params) {
        if (null == params) {
            throw new NullPointerException("params");
        }
        this.m_params = params;
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            String error = "Invalid key: " + key;
            throw new IllegalArgumentException(error);
        }
        Object current = super.get(key);
        if (null == value) {
            super.put(key, null);
            return current;
        }
        Parameter p = this.getParameter((String)key);
        try {
            Object v = p.resolve(value);
            if (p.getParameterClass().isInstance(v)) {
                super.put(key, v);
                return current;
            }
            String error = "Resolved value: " + v + " does not implement the parameter type: " + p.getParameterClass();
            throw new IllegalArgumentException(error);
        }
        catch (Throwable e) {
            String error = "Unable to assign a value to the key: " + key;
            throw new CriteriaRuntimeException(error, e);
        }
    }

    public Object get(Object key) {
        Parameter param = this.getParameterFromObject(key);
        Object value = super.get(param.getKey());
        if (null != value) {
            return value;
        }
        return param.getDefault();
    }

    protected Object getValue(Parameter param) {
        return this.get(param.getKey());
    }

    protected String[] getKeys() {
        return Parameter.getKeys(this.getParameters());
    }

    protected Parameter[] getParameters() {
        return this.m_params;
    }

    protected Parameter getParameter(String key) {
        Parameter[] params = this.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Parameter parameter = params[i];
            if (!parameter.getKey().equals(key)) continue;
            return parameter;
        }
        String error = "Unknown key: [" + key + "].";
        throw new IllegalArgumentException(error);
    }

    private Parameter getParameterFromObject(Object key) {
        if (key instanceof Parameter) {
            return (Parameter)key;
        }
        return this.getParameter(key.toString());
    }
}

