/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.RepositoryException;

public class LoaderUtils {
    private boolean m_online;

    public LoaderUtils(boolean online) {
        this.m_online = online;
    }

    public URL getResource(Artifact artifact, String[] repositories, File root, boolean timestamping) throws RepositoryException {
        Exception cause = null;
        File destination = new File(root, artifact.getPath());
        if (!this.m_online) {
            if (destination.exists()) {
                return LoaderUtils.getURL(destination);
            }
            String error = "Artifact [" + artifact + "] does not exist in local cache.";
            throw new RepositoryException(error);
        }
        for (int i = 0; i < repositories.length; ++i) {
            try {
                String url = artifact.getURL(repositories[i]);
                return this.getResource(url, destination, timestamping);
            }
            catch (Exception e) {
                cause = e;
                continue;
            }
        }
        if (destination.exists()) {
            return LoaderUtils.getURL(destination);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Failed to download artifact to local cache file " + destination.getAbsolutePath() + " from hosts: ");
        for (int i = 0; i < repositories.length; ++i) {
            buffer.append("\n  " + repositories[i]);
        }
        throw new RepositoryException(buffer.toString(), cause);
    }

    public URL getResource(Artifact artifact, String mime, String[] repositories, File root, boolean timestamping) throws RepositoryException {
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        if (null == mime) {
            throw new NullPointerException("mime");
        }
        if (null == root) {
            throw new NullPointerException("root");
        }
        if (null == repositories) {
            throw new NullPointerException("repositories");
        }
        Exception cause = null;
        File destination = new File(root, artifact.getPath() + "." + mime);
        if (!this.m_online) {
            if (destination.exists()) {
                return LoaderUtils.getURL(destination);
            }
            String error = "Artifact [" + artifact.getPath() + "." + mime + "] does not exist in local cache.";
            throw new RepositoryException(error);
        }
        for (int i = 0; i < repositories.length; ++i) {
            try {
                String url = artifact.getURL(repositories[i]) + "." + mime;
                return this.getResource(url, destination, timestamping);
            }
            catch (Exception e) {
                cause = e;
                continue;
            }
        }
        if (destination.exists()) {
            return LoaderUtils.getURL(destination);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Failed to download mime artifact to local cache file " + destination.getAbsolutePath() + " from hosts: ");
        for (int i = 0; i < repositories.length; ++i) {
            buffer.append("\n  " + repositories[i]);
        }
        throw new RepositoryException(buffer.toString(), cause);
    }

    public URL getResource(String url, File destination, boolean timestamping) throws Exception {
        boolean update = destination.exists();
        long remoteTimestamp = 0L;
        if (timestamping && destination.exists() && url.startsWith("file:")) {
            try {
                URL sourceFileUrl = new URL(url);
                String sourcePath = sourceFileUrl.getPath();
                File sourceFile = new File(sourcePath);
                if (destination.lastModified() >= sourceFile.lastModified()) {
                    return destination.toURL();
                }
                remoteTimestamp = sourceFile.lastModified();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!this.m_online) {
            if (destination.exists()) {
                return LoaderUtils.getURL(destination);
            }
            String error = "Cannot retrieve url [" + url + "] while disconnected.";
            throw new RepositoryException(error);
        }
        if (destination.exists() && !LoaderUtils.isSnapshot(destination)) {
            return LoaderUtils.getURL(destination);
        }
        URL source = null;
        String username = null;
        String password = null;
        int atIdx = url.indexOf("@");
        if (atIdx > 0) {
            String s = url.substring(7, atIdx);
            int colon = s.indexOf(":");
            username = s.substring(0, colon);
            password = s.substring(colon + 1);
            source = new URL("http://" + url.substring(atIdx + 1));
        } else {
            source = new URL(url);
        }
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (timestamping && destination.exists()) {
            timestamp = destination.lastModified();
            hasTimestamp = true;
        }
        URLConnection connection = source.openConnection();
        if (timestamping && hasTimestamp) {
            connection.setIfModifiedSince(timestamp);
        }
        connection.connect();
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            if (httpConnection.getResponseCode() == 304) {
                return destination.toURL();
            }
            if (httpConnection.getResponseCode() == 401) {
                throw new Exception("Not authorized.");
            }
        }
        InputStream in = null;
        for (int ii = 0; ii < 3; ++ii) {
            try {
                in = connection.getInputStream();
                break;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (in == null) {
            String error = "Connection returned a null input stream: " + url;
            throw new IOException(error);
        }
        File parent = destination.getParentFile();
        parent.mkdirs();
        File tempFile = File.createTempFile("~avalon", ".tmp", parent);
        tempFile.deleteOnExit();
        FileOutputStream tempOut = new FileOutputStream(tempFile);
        String title = update ? "Update from: [" + source + "] " : "Download from: [" + source + "] ";
        LoaderUtils.copyStream(in, tempOut, true, title);
        tempFile.renameTo(destination);
        if (timestamping) {
            if (remoteTimestamp == 0L) {
                remoteTimestamp = connection.getLastModified();
            }
            if (remoteTimestamp < 0L) {
                destination.setLastModified(System.currentTimeMillis());
            } else {
                destination.setLastModified(remoteTimestamp);
            }
        }
        return destination.toURL();
    }

    private static boolean isSnapshot(File file) {
        return file.getName().endsWith("SNAPSHOT");
    }

    private static URL getURL(File file) throws RepositoryException {
        try {
            return file.toURL();
        }
        catch (Throwable e) {
            String error = "Internal error while attempting to create a url from the file: " + file;
            throw new RepositoryException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream src, OutputStream dest, boolean closeStreams, String title) throws IOException {
        boolean progress;
        block10: {
            block11: {
                progress = title != null;
                byte[] buffer = new byte[102400];
                if (title != null) {
                    System.out.println(title);
                }
                try {
                    int length;
                    while ((length = src.read(buffer)) >= 0) {
                        dest.write(buffer, 0, length);
                        if (!progress) continue;
                        System.out.print(".");
                    }
                    Object var8_7 = null;
                    if (!closeStreams) break block10;
                    if (src == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (closeStreams) {
                        if (src != null) {
                            src.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                    }
                    if (progress) {
                        System.out.println("");
                    }
                    throw throwable;
                }
                src.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
        if (progress) {
            System.out.println("");
        }
    }
}

