/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.main;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.RepositoryRuntimeException;
import org.apache.avalon.repository.main.DefaultInitialContext;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.repository.provider.InitialContextFactory;
import org.apache.avalon.util.defaults.Defaults;
import org.apache.avalon.util.defaults.DefaultsBuilder;

public class DefaultInitialContextFactory
implements InitialContextFactory {
    private static final String AVALON_PROPERTIES = "avalon.properties";
    private final String m_key;
    private final File m_work;
    private final DefaultsBuilder m_defaults;
    private final Properties m_properties;
    private File m_cache;
    private Artifact m_artifact;
    private ClassLoader m_classloader;
    private String[] m_hosts;
    private String m_proxyHost;
    private int m_proxyPort;
    private String m_proxyUsername;
    private String m_proxyPassword;
    private boolean m_online = true;
    private Artifact[] m_registry;
    static /* synthetic */ Class class$org$apache$avalon$repository$main$DefaultInitialContext;
    static /* synthetic */ Class class$org$apache$avalon$repository$main$DefaultInitialContextFactory;

    public DefaultInitialContextFactory(String key) throws IOException {
        this(key, new File(System.getProperty("user.dir")));
    }

    public DefaultInitialContextFactory(String key, File work) throws IOException {
        if (null == key) {
            throw new NullPointerException("key");
        }
        if (null == work) {
            throw new NullPointerException("work");
        }
        this.m_key = key;
        this.m_work = work;
        this.m_defaults = new DefaultsBuilder(key, work);
        this.m_properties = this.m_defaults.getConsolidatedProperties(this.getDefaultProperties(), InitialContextFactory.KEYS);
        Defaults.macroExpand(this.m_properties, new Properties[]{this.m_properties});
        String spec = this.m_properties.getProperty("avalon.repository.implementation");
        if (null == spec) {
            String error = "Required implementation key [avalon.repository.implementation] not found.";
            throw new IllegalStateException("Required implementation key [avalon.repository.implementation] not found.");
        }
        this.m_artifact = Artifact.createArtifact(spec);
    }

    public void setFactoryArtifacts(Artifact[] artifacts) {
        this.m_registry = artifacts;
    }

    public void setOnlineMode(boolean policy) {
        this.m_online = policy;
    }

    public void setParentClassLoader(ClassLoader classloader) {
        this.m_classloader = classloader;
    }

    public void setImplementation(Artifact artifact) {
        this.m_artifact = artifact;
    }

    public void setCacheDirectory(File cache) {
        this.m_cache = cache;
    }

    public void setHosts(String[] hosts) {
        this.m_hosts = hosts;
    }

    public void setProxyHost(String host) {
        this.m_proxyHost = host;
    }

    public void setProxyPort(int port) {
        this.m_proxyPort = port;
    }

    public void setProxyUsername(String username) {
        this.m_proxyUsername = username;
    }

    public void setProxyPassword(String password) {
        this.m_proxyPassword = password;
    }

    public InitialContext createInitialContext() {
        try {
            return new DefaultInitialContext(this.getApplicationKey(), this.getParentClassLoader(), this.getImplementation(), this.getRegisteredArtifacts(), this.getWorkingDirectory(), this.getCacheDirectory(), this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword(), this.getHosts(), this.getOnlineMode());
        }
        catch (Throwable e) {
            String error = "Could not create initial context.";
            throw new RepositoryRuntimeException("Could not create initial context.", e);
        }
    }

    public Artifact[] getRegisteredArtifacts() {
        if (null != this.m_registry) {
            return this.m_registry;
        }
        return new Artifact[0];
    }

    public boolean getOnlineMode() {
        return this.m_online;
    }

    public String getApplicationKey() {
        return this.m_key;
    }

    public File getHomeDirectory() {
        return this.m_defaults.getHomeDirectory();
    }

    public File getWorkingDirectory() {
        return this.m_work;
    }

    public ClassLoader getParentClassLoader() {
        if (null != this.m_classloader) {
            return this.m_classloader;
        }
        return (class$org$apache$avalon$repository$main$DefaultInitialContext == null ? (class$org$apache$avalon$repository$main$DefaultInitialContext = DefaultInitialContextFactory.class$("org.apache.avalon.repository.main.DefaultInitialContext")) : class$org$apache$avalon$repository$main$DefaultInitialContext).getClassLoader();
    }

    public Artifact getImplementation() {
        return this.m_artifact;
    }

    public File getCacheDirectory() {
        if (null != this.m_cache) {
            return this.m_cache;
        }
        String value = this.m_properties.getProperty("avalon.repository.cache");
        if (null != value) {
            return new File(value);
        }
        return new File(this.getHomeDirectory(), "repository");
    }

    public String[] getHosts() {
        if (null != this.m_hosts) {
            return this.m_hosts;
        }
        String value = this.m_properties.getProperty("avalon.repository.hosts");
        if (null == value) {
            return new String[0];
        }
        return DefaultInitialContextFactory.expandHosts(value);
    }

    public String getProxyHost() {
        if (null != this.m_proxyHost) {
            return this.m_proxyHost;
        }
        return this.m_properties.getProperty("avalon.repository.proxy.host");
    }

    public int getProxyPort() {
        if (this.m_proxyPort > -1) {
            return this.m_proxyPort;
        }
        String value = this.m_properties.getProperty("avalon.repository.proxy.port");
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public String getProxyUsername() {
        if (null != this.m_proxyUsername) {
            return this.m_proxyUsername;
        }
        return this.m_properties.getProperty("avalon.repository.proxy.username");
    }

    public String getProxyPassword() {
        if (null != this.m_proxyPassword) {
            return this.m_proxyPassword;
        }
        return this.m_properties.getProperty("avalon.repository.proxy.password");
    }

    private Properties getDefaultProperties() throws IOException {
        Properties properties = new Properties();
        ClassLoader classloader = (class$org$apache$avalon$repository$main$DefaultInitialContextFactory == null ? (class$org$apache$avalon$repository$main$DefaultInitialContextFactory = DefaultInitialContextFactory.class$("org.apache.avalon.repository.main.DefaultInitialContextFactory")) : class$org$apache$avalon$repository$main$DefaultInitialContextFactory).getClassLoader();
        InputStream input = classloader.getResourceAsStream(AVALON_PROPERTIES);
        if (input == null) {
            String error = "Missing resource: [avalon.properties]";
            throw new Error("Missing resource: [avalon.properties]");
        }
        properties.load(input);
        return properties;
    }

    private static String[] expandHosts(String arg) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(arg, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

