/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository;

import java.io.IOException;
import java.net.URL;
import org.apache.avalon.repository.AbstractURLConnection;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.CascadingIOException;

public class ArtifactURLConnection
extends AbstractURLConnection {
    ArtifactURLConnection(URL url) throws NullPointerException, IOException {
        super(url);
    }

    public Object getContent() throws IOException {
        return this.getContent("jar");
    }

    protected Object getContent(String defaultType) throws IOException {
        try {
            String path = this.getURL().getPath();
            int i = path.lastIndexOf("/");
            String group = path.substring(0, i);
            String name = path.substring(i + 1);
            String version = this.getVersion(this.url);
            String type = this.getType(this.getURL(), defaultType);
            return Artifact.createArtifact(group, name, version, type);
        }
        catch (Throwable e) {
            String error = "Unexpected exception while resolving url [" + this.getURL() + "].";
            throw new CascadingIOException(error);
        }
    }

    private String getType(URL url, String type) {
        return this.getQueryField(url, "type", type);
    }
}

