/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.avalon.repository.ArtifactHandler;

public class Artifact
implements Serializable {
    public static final String SEP = "/";
    public static final String GROUP_KEY = "avalon.artifact.group";
    public static final String NAME_KEY = "avalon.artifact.name";
    public static final String VERSION_KEY = "avalon.artifact.version";
    public static final String TYPE_KEY = "avalon.artifact.type";
    private final String m_base;
    private final String m_filename;
    private final String m_path;
    private final String m_group;
    private final String m_name;
    private final String m_type;
    private final String m_version;

    public static Artifact createArtifact(String spec) {
        if (null == spec) {
            throw new NullPointerException("spec");
        }
        if (spec.startsWith("artifact:")) {
            try {
                URL url = new URL(null, spec, new ArtifactHandler());
                Artifact artifact = (Artifact)url.getContent();
                return artifact;
            }
            catch (IOException e) {
                String error = "Bad artifact url [" + spec + "] " + e.getMessage();
                throw new IllegalArgumentException(error);
            }
        }
        String version = Artifact.getVersion(spec);
        String group = Artifact.getGroup(spec);
        String name = Artifact.getName(spec);
        return Artifact.createArtifact(group, name, version);
    }

    public static Artifact createArtifact(String group, String name, String version) {
        return Artifact.createArtifact(group, name, version, "jar");
    }

    public static Artifact createArtifact(String group, String name, String version, String type) {
        if (group == null) {
            throw new NullPointerException("group");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        return new Artifact(group, name, version, type);
    }

    private Artifact(String group, String name, String version, String type) {
        this.m_group = group;
        this.m_name = name;
        this.m_version = version;
        this.m_type = type;
        String base = Artifact.createBase(group, type);
        this.m_base = this.getCleanPath(base);
        String filename = Artifact.createFilename(name, version, type);
        if (filename.indexOf(SEP) > 0) {
            String error = "Invalid name - illegal character '/' in filename: " + filename;
            throw new IllegalArgumentException(error);
        }
        this.m_filename = filename;
        this.m_path = this.m_base + SEP + this.m_filename;
    }

    public String getURL() {
        return this.getURL(null);
    }

    public String getURL(String host) {
        if (null == host) {
            return this.getURL("");
        }
        if (host.endsWith(SEP)) {
            return host + this.getPath();
        }
        return host + SEP + this.getPath();
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getSpecification() {
        String group = this.getGroup();
        String name = this.getName();
        StringBuffer buffer = new StringBuffer();
        buffer.append(group);
        buffer.append(SEP);
        buffer.append(name);
        String version = this.getVersion();
        if (version != null) {
            buffer.append('#');
            buffer.append(version);
        }
        return buffer.toString();
    }

    public String getBase() {
        return this.m_base;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getPath() {
        return this.m_path;
    }

    public String toString() {
        if ("block".equals(this.getType())) {
            return "block:" + this.getSpecification();
        }
        if ("jar".equals(this.getType())) {
            return "artifact:" + this.getSpecification();
        }
        String path = "artifact:" + this.getGroup() + SEP + this.getName();
        if (this.getVersion() != null) {
            path = path + "#" + this.getVersion();
            if (this.getType() != null) {
                path = path + "&type=" + this.getType();
            }
            return path;
        }
        if (this.getType() != null) {
            path = path + "?type=" + this.getType();
        }
        return path;
    }

    private static String createBase(String group, String type) {
        if (type == null) {
            return group;
        }
        return group + SEP + type + "s";
    }

    private static String createFilename(String name, String version, String type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        StringBuffer buffer = new StringBuffer(name);
        if (version != null) {
            buffer.append("-");
            buffer.append(version);
        }
        if (type != null) {
            buffer.append(".");
            buffer.append(type);
        }
        return buffer.toString();
    }

    private static String getGroup(String spec) {
        int semiColon = spec.indexOf(59);
        if (-1 == semiColon) {
            int colon = spec.indexOf(58);
            if (-1 == colon) {
                return spec;
            }
            return spec.substring(0, colon);
        }
        return Artifact.getGroup(spec.substring(0, semiColon - 1));
    }

    private static String getName(String spec) {
        int semiColon = spec.indexOf(59);
        if (-1 == semiColon) {
            int colon = spec.indexOf(58);
            if (-1 == colon) {
                return spec;
            }
            return spec.substring(colon + 1, spec.length());
        }
        return Artifact.getName(spec.substring(0, semiColon));
    }

    private static String getVersion(String spec) {
        int semiColon = spec.indexOf(59);
        if (-1 == semiColon) {
            return null;
        }
        return spec.substring(semiColon + 1, spec.length());
    }

    private String getCleanPath(String path) {
        if (path.startsWith(SEP)) {
            return this.getCleanPath(path.substring(1, path.length()));
        }
        if (path.endsWith(SEP)) {
            return this.getCleanPath(path.substring(0, path.length() - 1));
        }
        return path;
    }
}

