/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class DefaultMessageHandler
implements IMessageHandler {
    boolean isVerbose = false;
    boolean showWeaveInfo = false;
    boolean showWarn = true;

    public boolean handleMessage(IMessage message) throws AbortException {
        if (this.isIgnoring(message.getKind())) {
            return false;
        }
        if (message.getKind().isSameOrLessThan(IMessage.INFO)) {
            return IMessageHandler.SYSTEM_OUT.handleMessage(message);
        }
        return IMessageHandler.SYSTEM_ERR.handleMessage(message);
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        if (kind.equals(IMessage.WEAVEINFO)) {
            return !this.showWeaveInfo;
        }
        if (kind.isSameOrLessThan(IMessage.INFO)) {
            return !this.isVerbose;
        }
        return !this.showWarn;
    }

    public void dontIgnore(IMessage.Kind kind) {
        if (kind.equals(IMessage.WEAVEINFO)) {
            this.showWeaveInfo = true;
        } else if (kind.equals(IMessage.DEBUG)) {
            this.isVerbose = true;
        } else if (kind.equals(IMessage.WARNING)) {
            this.showWarn = false;
        }
    }
}

