/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.stream.sdk.resource;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource<T> {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    protected String name;
    protected T object;

    public Resource(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final T get() {
        return this.object;
    }

    public boolean validate() {
        return true;
    }

    public abstract T create(Map<String, Object> var1);

    public abstract void destroy();

    public final void build(Map<String, Object> configMap) {
        if (this.object != null) {
            return;
        }
        try {
            this.object = this.create(configMap);
        }
        catch (Exception e) {
            logger.error("build resource[{}] failed", (Object)this.name);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

