/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.environment;

import java.io.File;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.test.util.TestUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0005J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ltech/harmonysoft/oss/environment/TestContext;", "", "rootDir", "Ljava/io/File;", "executionId", "", "(Ljava/io/File;Ljava/lang/String;)V", "getExecutionId", "()Ljava/lang/String;", "getRootDir", "()Ljava/io/File;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "prepareDirectory", "path", "toString", "harmonysoft-test-environment"})
public final class TestContext {
    @NotNull
    private final File rootDir;
    @NotNull
    private final String executionId;

    public TestContext(@NotNull File rootDir, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.rootDir = rootDir;
        this.executionId = executionId;
    }

    @NotNull
    public final File getRootDir() {
        return this.rootDir;
    }

    @NotNull
    public final String getExecutionId() {
        return this.executionId;
    }

    @NotNull
    public final File prepareDirectory(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File result = new File(this.rootDir, path);
        if (result.isDirectory()) {
            return result;
        }
        if (result.exists()) {
            TestUtil.INSTANCE.fail("can't create test directory " + result.getCanonicalPath() + " - there is a file at the target path");
            throw new KotlinNothingValueException();
        }
        boolean ok = result.mkdirs();
        if (!ok) {
            TestUtil.INSTANCE.fail("can't create auxiliary directory " + result.getCanonicalPath());
            throw new KotlinNothingValueException();
        }
        return result;
    }

    @NotNull
    public final File component1() {
        return this.rootDir;
    }

    @NotNull
    public final String component2() {
        return this.executionId;
    }

    @NotNull
    public final TestContext copy(@NotNull File rootDir, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return new TestContext(rootDir, executionId);
    }

    public static /* synthetic */ TestContext copy$default(TestContext testContext, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = testContext.rootDir;
        }
        if ((n & 2) != 0) {
            string = testContext.executionId;
        }
        return testContext.copy(file, string);
    }

    @NotNull
    public String toString() {
        return "TestContext(rootDir=" + this.rootDir + ", executionId=" + this.executionId + ')';
    }

    public int hashCode() {
        int result = this.rootDir.hashCode();
        result = result * 31 + this.executionId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TestContext)) {
            return false;
        }
        TestContext testContext = (TestContext)other;
        if (!Intrinsics.areEqual((Object)this.rootDir, (Object)testContext.rootDir)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.executionId, (Object)testContext.executionId);
    }
}

