/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.monitor.global;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.CollectionUtils;
import plus.jdk.monitor.annotation.MemoryMonitorDotCompont;
import plus.jdk.monitor.common.IMonitorMemoryDotCallback;
import plus.jdk.monitor.model.MemoryDotModel;
import plus.jdk.monitor.properties.MonitorMemoryProperties;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.attach.HotSpotVirtualMachine;

public class MemoryMonitorDispatcher
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(MemoryMonitorDispatcher.class);
    private MonitorMemoryProperties monitorMemoryProperties;
    private ApplicationContext applicationContext;
    private final List<MemoryDotModel> memoryDotModels = new ArrayList<MemoryDotModel>();
    private String currentProcessId = null;
    private String currentProcessJMXUri = null;

    public MemoryMonitorDispatcher(MonitorMemoryProperties monitorMemoryProperties, ApplicationContext applicationContext) {
        this.monitorMemoryProperties = monitorMemoryProperties;
        this.applicationContext = applicationContext;
    }

    public void monitorDot() {
        for (MemoryDotModel memoryDotModel : this.memoryDotModels) {
            try {
                this.doMemoryDot(memoryPoolMXBean -> memoryDotModel.getDotCallback().doDot(memoryPoolMXBean));
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                log.error("{}", (Object)e.getMessage());
            }
        }
    }

    public void initProcessInfo() throws ClassNotFoundException {
        if (this.currentProcessId != null) {
            return;
        }
        Class<?> mainClass = this.getMainClass();
        this.currentProcessId = this.getProcessId(mainClass);
        this.currentProcessJMXUri = this.bindJMXAgentAndGetJMXUri(this.currentProcessId);
    }

    public void findDotCallbackService() {
        String[] beanNames;
        if (!CollectionUtils.isEmpty(this.memoryDotModels)) {
            return;
        }
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(MemoryMonitorDotCompont.class)) {
            IMonitorMemoryDotCallback dotCallback = (IMonitorMemoryDotCallback)this.applicationContext.getBean(beanName, IMonitorMemoryDotCallback.class);
            MemoryMonitorDotCompont dotService = (MemoryMonitorDotCompont)this.applicationContext.findAnnotationOnBean(beanName, MemoryMonitorDotCompont.class);
            if (dotService == null) continue;
            this.memoryDotModels.add(new MemoryDotModel(dotCallback, dotService));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStack(String pid) {
        VirtualMachine virtualMachine = null;
        InputStream is = null;
        try {
            virtualMachine = VirtualMachine.attach(pid);
            HotSpotVirtualMachine machine = (HotSpotVirtualMachine)virtualMachine;
            is = machine.remoteDataDump(new String[0]);
            String string = IOUtils.toString((InputStream)is, (String)StandardCharsets.UTF_8.name());
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String heapHisto(String pid) {
        VirtualMachine virtualMachine = null;
        InputStream is = null;
        try {
            virtualMachine = VirtualMachine.attach(pid);
            HotSpotVirtualMachine machine = (HotSpotVirtualMachine)virtualMachine;
            is = machine.heapHisto(new String[0]);
            String string = IOUtils.toString((InputStream)is, (String)StandardCharsets.UTF_8.name());
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    public void doMemoryDot(IMonitorMemoryDotCallback callback) {
        this.doMemoryDot(this.currentProcessJMXUri, callback);
    }

    public void doMemoryDot(String jmxAddress, IMonitorMemoryDotCallback callback) {
        try {
            JMXServiceURL target = new JMXServiceURL(jmxAddress);
            JMXConnector connector = JMXConnectorFactory.connect(target);
            MBeanServerConnection mBeanServerConnection = connector.getMBeanServerConnection();
            TimeUnit.SECONDS.sleep(1L);
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getPlatformMXBeans(mBeanServerConnection, MemoryPoolMXBean.class);
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                try {
                    callback.doDot(memoryPoolMXBean);
                }
                catch (Error | Exception throwable) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized String bindJMXAgentAndGetJMXUri(String pid) {
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = VirtualMachine.attach(pid);
            String javaHome = virtualMachine.getSystemProperties().getProperty("java.home");
            String jmxAgent = String.join((CharSequence)File.separator, javaHome, "lib", "management-agent.jar");
            virtualMachine.loadAgent(jmxAgent, "com.sun.management.jmxremote");
            Properties properties = virtualMachine.getAgentProperties();
            String address = (String)properties.get("com.sun.management.jmxremote.localConnectorAddress");
            virtualMachine.detach();
            return address;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProcessId(Class<?> mainClass) {
        try {
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            Set<Integer> activeVmProcessIds = monitoredHost.activeVms();
            MonitoredVm mvm = null;
            Iterator<Integer> iterator = activeVmProcessIds.iterator();
            while (iterator.hasNext()) {
                Integer vmPid = iterator.next();
                try {
                    mvm = monitoredHost.getMonitoredVm(new VmIdentifier(vmPid.toString()));
                    String mvmMainClass = MonitoredVmUtil.mainClass(mvm, true);
                    if (!mainClass.getName().equals(mvmMainClass)) continue;
                    String string = String.valueOf(vmPid);
                    return string;
                }
                finally {
                    if (mvm == null) continue;
                    mvm.detach();
                }
            }
            return null;
        }
        catch (URISyntaxException | MonitorException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public Class<?> getMainClass() throws ClassNotFoundException {
        StackTraceElement[] stackTraceElements;
        for (StackTraceElement stackTraceElement : stackTraceElements = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            return Class.forName(stackTraceElement.getClassName());
        }
        return null;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        long fixRate = this.monitorMemoryProperties.getFixRate() * 1000;
        PeriodicTrigger eventTrigger = new PeriodicTrigger(fixRate);
        taskRegistrar.addTriggerTask(this::monitorDot, (Trigger)eventTrigger);
    }

    public static void main(String[] args) throws ClassNotFoundException {
        MemoryMonitorDispatcher dispatcher = new MemoryMonitorDispatcher();
        String pid = String.valueOf(dispatcher.getProcessId(dispatcher.getMainClass()));
        String jxmAddress = dispatcher.bindJMXAgentAndGetJMXUri(pid);
        dispatcher.doMemoryDot(jxmAddress, memoryPoolMXBean -> {
            String name = memoryPoolMXBean.getName();
            CharSequence[] memoryManagerNames = memoryPoolMXBean.getMemoryManagerNames();
            MemoryType type = memoryPoolMXBean.getType();
            MemoryUsage usage = memoryPoolMXBean.getUsage();
            MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
            memoryPoolMXBean.getCollectionUsage();
            System.out.println(name + ":");
            System.out.println("    managers: " + String.join((CharSequence)" , ", memoryManagerNames));
            System.out.println("    type: " + type.toString());
            System.out.print("    usage: " + usage.toString());
            System.out.println("    Percentage: " + (double)usage.getUsed() / (double)usage.getCommitted());
            System.out.println("    peakUsage: " + peakUsage.toString());
            System.out.println("");
        });
        dispatcher.heapHisto(pid);
        MemoryMonitorDispatcher.getStack(pid);
    }

    public MemoryMonitorDispatcher() {
    }
}

