/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.xmlrpc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.secure.SecureWebServer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.xmlrpc.Client;
import org.codehaus.plexus.xmlrpc.Handler;
import org.codehaus.plexus.xmlrpc.XmlRpcComponent;
import org.codehaus.plexus.xmlrpc.XmlRpcMessageListener;

public class DefaultXmlRpcComponent
extends AbstractLogEnabled
implements Contextualizable,
Initializable,
Startable,
XmlRpcComponent {
    private PlexusContainer container;
    private int port;
    private boolean isSecureServer;
    private String saxParserClass;
    private boolean paranoid;
    private List handlers;
    private List acceptedClients;
    private List deniedClients;
    private Properties systemProperties;
    private List listeners = new ArrayList();
    private WebServer webserver;
    static /* synthetic */ Class class$org$codehaus$plexus$xmlrpc$Client;

    public void acceptClient(String string) {
        this.webserver.acceptClient(string);
    }

    public void addMessageListener(XmlRpcMessageListener xmlRpcMessageListener) {
        this.listeners.add(xmlRpcMessageListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void denyClient(String string) {
        this.webserver.denyClient(string);
    }

    public Object executeRpc(URL uRL, String string, Vector vector) throws Exception {
        try {
            XmlRpcClient xmlRpcClient = new XmlRpcClient(uRL);
            return xmlRpcClient.execute(string, vector);
        }
        catch (Exception exception) {
            throw new Exception("XML-RPC call failed", exception);
        }
    }

    private String getClient(List list, int n) throws PlexusConfigurationException {
        Object e = list.get(n);
        if (!(e instanceof Client)) {
            throw new PlexusConfigurationException("The client address element must be a '" + (class$org$codehaus$plexus$xmlrpc$Client != null ? class$org$codehaus$plexus$xmlrpc$Client : (class$org$codehaus$plexus$xmlrpc$Client = DefaultXmlRpcComponent.class$("org.codehaus.plexus.xmlrpc.Client"))).getName() + "'.");
        }
        Client client = (Client)e;
        return client.getHostname();
    }

    public void initialize() throws Exception {
        this.setSystemPropertiesFromConfiguration();
        if (this.port == 0) {
            this.port = 8080;
        }
        this.getLogger().info("Attempting to start the XML-RPC server on port " + this.port + ".");
        this.webserver = this.isSecureServer ? new SecureWebServer(this.port) : new WebServer(this.port);
        if (this.saxParserClass != null) {
            XmlRpc.setDriver((String)this.saxParserClass);
        }
        this.registerStartupHandlers();
        if (this.paranoid) {
            this.webserver.setParanoid(this.paranoid);
            this.getLogger().info("Operating in a state of paranoia");
            if (this.acceptedClients == null) {
                throw new PlexusConfigurationException("When in state of paranoia a list of 'acceptedClients' is required.");
            }
            int n = 0;
            while (n < this.acceptedClients.size()) {
                String string = this.getClient(this.acceptedClients, n);
                this.webserver.acceptClient(string);
                this.getLogger().info("Accepting client -> " + string);
                ++n;
            }
            if (this.deniedClients == null) {
                throw new PlexusConfigurationException("When in state of paranoia a list of 'deniedClients' is required.");
            }
            int n2 = 0;
            while (n2 < this.deniedClients.size()) {
                String string = this.getClient(this.acceptedClients, n2);
                this.webserver.denyClient(string);
                this.getLogger().info("Denying client -> " + string);
                ++n2;
            }
        }
    }

    public void messageReceived(String string) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            XmlRpcMessageListener xmlRpcMessageListener = (XmlRpcMessageListener)iterator.next();
            xmlRpcMessageListener.xmlRpcMessageReceived(string);
        }
    }

    private void registerComponentHandler(String string, String string2) throws Exception {
        this.registerHandler(string, this.container.lookup(string2));
        this.getLogger().info("registered: " + string + " with component: " + string2);
    }

    public void registerHandler(Object object) throws XmlRpcException, IOException {
        this.registerHandler("$default", object);
    }

    public void registerHandler(String string, Object object) throws XmlRpcException, IOException {
        this.webserver.addHandler(string, object);
    }

    private void registerStartupHandlers() throws Exception {
        if (this.handlers == null) {
            this.getLogger().warn("No handlers to configure.");
            return;
        }
        this.getLogger().info("We have " + this.handlers.size() + " handlers to configure.");
        int n = 0;
        while (n < this.handlers.size()) {
            Object e = this.handlers.get(n);
            if (!(e instanceof Handler)) {
                this.getLogger().warn("Unknown object type in the handler array: " + e.getClass().getName());
            } else {
                Handler handler = (Handler)e;
                String string = handler.getName();
                String string2 = handler.getRole();
                if (string == null) {
                    throw new PlexusConfigurationException("Missing required configuration element: 'name' in 'handler'.");
                }
                if (string.trim().length() == 0) {
                    throw new PlexusConfigurationException("The 'name' element of a 'handler' cant be empty.");
                }
                if (string2 == null) {
                    throw new PlexusConfigurationException("Missing required configuration element: 'role' in 'handler'.");
                }
                if (string2.trim().length() == 0) {
                    throw new PlexusConfigurationException("The 'role element of a 'handler' cant be empty.");
                }
                this.registerComponentHandler(string, string2);
            }
            ++n;
        }
    }

    public void setParanoid(boolean bl) {
        this.webserver.setParanoid(bl);
    }

    private void setSystemPropertiesFromConfiguration() {
        if (this.systemProperties == null) {
            return;
        }
        Enumeration<?> enumeration = this.systemProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this.systemProperties.getProperty(string);
            System.setProperty(string, string2);
            this.getLogger().debug("Setting property: " + string + " => '" + string2 + "'.");
        }
    }

    public void start() throws Exception {
        this.webserver.start();
    }

    public void stop() throws Exception {
        this.webserver.shutdown();
        try {
            Socket socket = new Socket(InetAddress.getLocalHost(), this.port);
            socket.close();
        }
        catch (Exception exception) {
            this.getLogger().warn("It's possible the xmlrpc server was not shutdown: " + exception.getMessage());
        }
    }

    public void unregisterHandler(String string) {
        this.webserver.removeHandler(string);
    }
}

