/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.builder.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.builder.AbstractBuilder;
import org.codehaus.plexus.builder.service.ServiceBuilder;
import org.codehaus.plexus.builder.service.ServiceBuilderException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultServiceBuilder
extends AbstractBuilder
implements ServiceBuilder {
    public void build(String serviceName, File outputDirectory, File classes, List remoteRepositories, ArtifactRepository localRepository, Set serviceArtifacts, File serviceConfiguration, File configurationsDirectory, File configurationProperties) throws ServiceBuilderException {
        Set artifacts;
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new ServiceBuilderException("The service name must be set.");
        }
        if (configurationProperties != null && !configurationProperties.isFile()) {
            throw new ServiceBuilderException("The configuration properties file isn't a file: '" + configurationProperties.getAbsolutePath() + "'.");
        }
        if (configurationsDirectory != null && !configurationsDirectory.isDirectory()) {
            throw new ServiceBuilderException("The configurations directory isn't a directory: '" + configurationsDirectory.getAbsolutePath() + ".");
        }
        File confDir = this.mkdir(new File(outputDirectory, "conf"));
        File libDir = this.mkdir(new File(outputDirectory, "lib"));
        File classesDir = this.mkdir(new File(outputDirectory, "classes"));
        try {
            this.processConfigurations(confDir, serviceConfiguration, configurationProperties, configurationsDirectory);
        }
        catch (IOException e) {
            throw new ServiceBuilderException("Error while processing the configurations.");
        }
        try {
            HashSet excludedArtifacts = new HashSet();
            excludedArtifacts.addAll(this.getBootArtifacts(serviceArtifacts, remoteRepositories, localRepository, true));
            excludedArtifacts.addAll(this.getCoreArtifacts(serviceArtifacts, remoteRepositories, localRepository, true));
            AbstractBuilder.AndArtifactFilter filter = new AbstractBuilder.AndArtifactFilter(new AbstractBuilder.ScopeExcludeArtifactFilter("test"), new AbstractBuilder.GroupArtifactTypeArtifactFilter(excludedArtifacts));
            artifacts = this.findArtifacts(remoteRepositories, localRepository, serviceArtifacts, true, filter);
        }
        catch (ArtifactResolutionException e) {
            throw new ServiceBuilderException("Error while finding dependencies.", e);
        }
        try {
            FileUtils.copyDirectoryStructure((File)classes, (File)classesDir);
        }
        catch (IOException e) {
            throw new ServiceBuilderException("Error while copying the classes.", e);
        }
        try {
            this.copyArtifacts(outputDirectory, libDir, artifacts);
        }
        catch (IOException e) {
            throw new ServiceBuilderException("Error while copying dependencies.", e);
        }
    }

    public void bundle(File outputFile, File workingDirectory) throws ServiceBuilderException {
        JarArchiver archiver = new JarArchiver();
        try {
            archiver.addDirectory(workingDirectory);
            archiver.setDestFile(outputFile);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new ServiceBuilderException("Error while creating the service archive.", e);
        }
    }

    private void processConfigurations(File confDir, File plexusConfigurationFile, File configurationPropertiesFile, File configurationsDirectory) throws ServiceBuilderException, IOException {
        if (!plexusConfigurationFile.exists()) {
            throw new ServiceBuilderException("The application configuration file doesn't exist: '" + plexusConfigurationFile.getAbsolutePath() + "'.");
        }
        FileUtils.copyFile((File)plexusConfigurationFile, (File)new File(confDir, "service.xml"));
        if (configurationsDirectory == null) {
            return;
        }
        Properties configurationProperties = new Properties();
        if (configurationPropertiesFile != null) {
            configurationProperties.load(new FileInputStream(configurationPropertiesFile));
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(configurationsDirectory);
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/CVS/**");
        if (configurationPropertiesFile != null) {
            excludes.add(configurationPropertiesFile.getAbsolutePath());
        }
        scanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            File in = new File(configurationsDirectory, file);
            File out = new File(confDir, files[i]);
            this.filterCopy(in, out, (Map)configurationProperties);
        }
    }
}

