/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.RefungibleApi;
import network.unique.model.AccountRefungibleTokensResponse;
import network.unique.model.AddTokensMutationDefaultResponse1;
import network.unique.model.AddTokensMutationRequest1;
import network.unique.model.AllowanceRefungibleTokenResponse;
import network.unique.model.ApproveTokensMutationDefaultResponse1;
import network.unique.model.ApproveTokensMutationRequest1;
import network.unique.model.BurnDefaultResponse1;
import network.unique.model.BurnRequest1;
import network.unique.model.CollectionInfoWithSchemaResponse;
import network.unique.model.CreateCollectionMutationDefaultResponse;
import network.unique.model.CreateRefungibleCollectionMutationRequest;
import network.unique.model.RepartitionTokenMutationDefaultResponse;
import network.unique.model.RepartitionTokenMutationRequest;
import network.unique.model.TokenBalanceResponse;
import network.unique.model.TotalPiecesResponse;
import network.unique.model.TransferTokensMutationDefaultResponse1;
import network.unique.model.TransferTokensMutationRequest1;
import network.unique.service.MutationService;
import network.unique.service.RefungibleService;
import network.unique.service.impl.refungible.ApproveRefungibleTokensMutationServiceImpl;
import network.unique.service.impl.refungible.BurnRefungibleMutationServiceImpl;
import network.unique.service.impl.refungible.CreateRefungibleCollectionMutationServiceImpl;
import network.unique.service.impl.refungible.CreateRefungibleTokensMutationServiceImpl;
import network.unique.service.impl.refungible.RepartitionTokensMutationServiceImpl;
import network.unique.service.impl.refungible.TransferRefungibleTokensMutationServiceImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bH\u0016J,\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J0\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J(\u0010+\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0014\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\bH\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0016J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lnetwork/unique/service/impl/RefungibleServiceImpl;", "Lnetwork/unique/service/RefungibleService;", "basePath", "", "(Ljava/lang/String;)V", "api", "Lnetwork/unique/api/RefungibleApi;", "approveRefungibleTokens", "Lnetwork/unique/service/MutationService;", "Lnetwork/unique/model/ApproveTokensMutationRequest1;", "Lnetwork/unique/model/ApproveTokensMutationDefaultResponse1;", "burnRefungibleCollection", "Lnetwork/unique/model/BurnRequest1;", "Lnetwork/unique/model/BurnDefaultResponse1;", "createRefungibleCollection", "Lnetwork/unique/model/CreateRefungibleCollectionMutationRequest;", "Lnetwork/unique/model/CreateCollectionMutationDefaultResponse;", "createRefungibleTokens", "Lnetwork/unique/model/AddTokensMutationRequest1;", "Lnetwork/unique/model/AddTokensMutationDefaultResponse1;", "repartitionTokens", "Lnetwork/unique/model/RepartitionTokenMutationRequest;", "Lnetwork/unique/model/RepartitionTokenMutationDefaultResponse;", "transferRefungibleTokens", "Lnetwork/unique/model/TransferTokensMutationRequest1;", "Lnetwork/unique/model/TransferTokensMutationDefaultResponse1;", "getAccountRefungibleTokens", "Lnetwork/unique/model/AccountRefungibleTokensResponse;", "collectionId", "Ljava/math/BigDecimal;", "address", "at", "getApproveRefungibleTokens", "getBurnRefungibleCollection", "getCreateRefungibleCollection", "getCreateRefungibleTokens", "getRefungibleCollectionInfo", "Lnetwork/unique/model/CollectionInfoWithSchemaResponse;", "getRefungibleTokenAllowance", "Lnetwork/unique/model/AllowanceRefungibleTokenResponse;", "tokenId", "from", "to", "getRefungibleTokensBalance", "Lnetwork/unique/model/TokenBalanceResponse;", "getRepartitionTokens", "getTotalPieces", "Lnetwork/unique/model/TotalPiecesResponse;", "getTransferRefungibleTokens", "unique-sdk"})
public final class RefungibleServiceImpl
implements RefungibleService {
    @NotNull
    private final RefungibleApi api;
    @NotNull
    private final MutationService<CreateRefungibleCollectionMutationRequest, CreateCollectionMutationDefaultResponse> createRefungibleCollection;
    @NotNull
    private final MutationService<BurnRequest1, BurnDefaultResponse1> burnRefungibleCollection;
    @NotNull
    private final MutationService<AddTokensMutationRequest1, AddTokensMutationDefaultResponse1> createRefungibleTokens;
    @NotNull
    private final MutationService<TransferTokensMutationRequest1, TransferTokensMutationDefaultResponse1> transferRefungibleTokens;
    @NotNull
    private final MutationService<ApproveTokensMutationRequest1, ApproveTokensMutationDefaultResponse1> approveRefungibleTokens;
    @NotNull
    private final MutationService<RepartitionTokenMutationRequest, RepartitionTokenMutationDefaultResponse> repartitionTokens;

    public RefungibleServiceImpl(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new RefungibleApi(basePath, null, 2, null);
        this.createRefungibleCollection = new CreateRefungibleCollectionMutationServiceImpl(basePath);
        this.burnRefungibleCollection = new BurnRefungibleMutationServiceImpl(basePath);
        this.createRefungibleTokens = new CreateRefungibleTokensMutationServiceImpl(basePath);
        this.transferRefungibleTokens = new TransferRefungibleTokensMutationServiceImpl(basePath);
        this.approveRefungibleTokens = new ApproveRefungibleTokensMutationServiceImpl(basePath);
        this.repartitionTokens = new RepartitionTokensMutationServiceImpl(basePath);
    }

    @Override
    @NotNull
    public CollectionInfoWithSchemaResponse getRefungibleCollectionInfo(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.refungibleControllerGetCollection(collectionId, at);
    }

    @Override
    @NotNull
    public TokenBalanceResponse getRefungibleTokensBalance(@NotNull BigDecimal collectionId, @NotNull BigDecimal tokenId, @NotNull String address, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.refungibleControllerGetBalance(collectionId, tokenId, address, at);
    }

    @Override
    @NotNull
    public AllowanceRefungibleTokenResponse getRefungibleTokenAllowance(@NotNull BigDecimal collectionId, @NotNull BigDecimal tokenId, @NotNull String from, @NotNull String to, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.refungibleControllerAllowanceTokens(collectionId, tokenId, from, to, at);
    }

    @Override
    @NotNull
    public TotalPiecesResponse getTotalPieces(@NotNull BigDecimal collectionId, @NotNull BigDecimal tokenId) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        return this.api.refungibleControllerTotalPieces(collectionId, tokenId);
    }

    @Override
    @NotNull
    public AccountRefungibleTokensResponse getAccountRefungibleTokens(@NotNull BigDecimal collectionId, @NotNull String address, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.refungibleControllerGetAccountTokens(collectionId, address, at);
    }

    @Override
    @NotNull
    public MutationService<CreateRefungibleCollectionMutationRequest, CreateCollectionMutationDefaultResponse> getCreateRefungibleCollection(@NotNull BigDecimal collectionId, @NotNull String address, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.createRefungibleCollection;
    }

    @Override
    @NotNull
    public MutationService<BurnRequest1, BurnDefaultResponse1> getBurnRefungibleCollection() {
        return this.burnRefungibleCollection;
    }

    @Override
    @NotNull
    public MutationService<AddTokensMutationRequest1, AddTokensMutationDefaultResponse1> getCreateRefungibleTokens() {
        return this.createRefungibleTokens;
    }

    @Override
    @NotNull
    public MutationService<TransferTokensMutationRequest1, TransferTokensMutationDefaultResponse1> getTransferRefungibleTokens() {
        return this.transferRefungibleTokens;
    }

    @Override
    @NotNull
    public MutationService<ApproveTokensMutationRequest1, ApproveTokensMutationDefaultResponse1> getApproveRefungibleTokens() {
        return this.approveRefungibleTokens;
    }

    @Override
    @NotNull
    public MutationService<RepartitionTokenMutationRequest, RepartitionTokenMutationDefaultResponse> getRepartitionTokens() {
        return this.repartitionTokens;
    }
}

