/*
 * Decompiled with CFR 0.152.
 */
package network.unique.service.impl;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import network.unique.api.FungibleApi;
import network.unique.model.AddTokensMutationDefaultResponse;
import network.unique.model.AddTokensMutationRequest;
import network.unique.model.BalanceResponse;
import network.unique.model.CreateCollectionMutationDefaultResponse;
import network.unique.model.CreateFungibleCollectionMutationRequest;
import network.unique.model.FungibleCollectionInfoDto;
import network.unique.model.TransferTokensMutationDefaultResponse;
import network.unique.model.TransferTokensMutationRequest;
import network.unique.service.FungibleService;
import network.unique.service.MutationService;
import network.unique.service.impl.fungible.AddTokensMutationServiceImpl;
import network.unique.service.impl.fungible.CreateFungibleCollectionMutationServiceImpl;
import network.unique.service.impl.fungible.TransferTokensMutationServiceImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0006H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0006H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnetwork/unique/service/impl/FungibleServiceImpl;", "Lnetwork/unique/service/FungibleService;", "basePath", "", "(Ljava/lang/String;)V", "addTokensMutationService", "Lnetwork/unique/service/MutationService;", "Lnetwork/unique/model/AddTokensMutationRequest;", "Lnetwork/unique/model/AddTokensMutationDefaultResponse;", "api", "Lnetwork/unique/api/FungibleApi;", "createFungibleCollectionMutationService", "Lnetwork/unique/model/CreateFungibleCollectionMutationRequest;", "Lnetwork/unique/model/CreateCollectionMutationDefaultResponse;", "transferTokensMutationService", "Lnetwork/unique/model/TransferTokensMutationRequest;", "Lnetwork/unique/model/TransferTokensMutationDefaultResponse;", "getAddTokens", "getBalance", "Lnetwork/unique/model/BalanceResponse;", "collectionId", "Ljava/math/BigDecimal;", "address", "at", "getCreateFungibleCollection", "getFungibleCollectionInfo", "Lnetwork/unique/model/FungibleCollectionInfoDto;", "getTransferTokens", "unique-sdk"})
public final class FungibleServiceImpl
implements FungibleService {
    @NotNull
    private final FungibleApi api;
    @NotNull
    private final MutationService<AddTokensMutationRequest, AddTokensMutationDefaultResponse> addTokensMutationService;
    @NotNull
    private final MutationService<CreateFungibleCollectionMutationRequest, CreateCollectionMutationDefaultResponse> createFungibleCollectionMutationService;
    @NotNull
    private final MutationService<TransferTokensMutationRequest, TransferTokensMutationDefaultResponse> transferTokensMutationService;

    public FungibleServiceImpl(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.api = new FungibleApi(basePath, null, 2, null);
        this.addTokensMutationService = new AddTokensMutationServiceImpl(basePath);
        this.createFungibleCollectionMutationService = new CreateFungibleCollectionMutationServiceImpl(basePath);
        this.transferTokensMutationService = new TransferTokensMutationServiceImpl(basePath);
    }

    @Override
    @NotNull
    public FungibleCollectionInfoDto getFungibleCollectionInfo(@NotNull BigDecimal collectionId, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.fungibleControllerGetCollection(collectionId, at);
    }

    @Override
    @NotNull
    public BalanceResponse getBalance(@NotNull BigDecimal collectionId, @NotNull String address, @NotNull String at) {
        Intrinsics.checkNotNullParameter((Object)collectionId, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
        return this.api.fungibleControllerGetBalance(address, collectionId, at);
    }

    @Override
    @NotNull
    public MutationService<AddTokensMutationRequest, AddTokensMutationDefaultResponse> getAddTokens() {
        return this.addTokensMutationService;
    }

    @Override
    @NotNull
    public MutationService<CreateFungibleCollectionMutationRequest, CreateCollectionMutationDefaultResponse> getCreateFungibleCollection() {
        return this.createFungibleCollectionMutationService;
    }

    @Override
    @NotNull
    public MutationService<TransferTokensMutationRequest, TransferTokensMutationDefaultResponse> getTransferTokens() {
        return this.transferTokensMutationService;
    }
}

