/*
 * Decompiled with CFR 0.152.
 */
package network.unique.model;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import network.unique.model.NativePairWrapper;
import network.unique.model.SignerWrapper;
import network.unique.model.Sr25519SignerWrapper;
import network.unique.signer.CryptoScheme;
import network.unique.signer.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnetwork/unique/model/Sr25519SignerWrapper;", "Lnetwork/unique/model/SignerWrapper;", "seed", "", "password", "generate", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "pair", "Lnetwork/unique/signer/Pair;", "close", "", "sign", "data", "unique-sdk"})
public final class Sr25519SignerWrapper
implements SignerWrapper {
    @NotNull
    private Pair pair;

    public Sr25519SignerWrapper(@NotNull String seed, @Nullable String password, boolean generate) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        if (generate) {
            String pairStr = Pair.generate((CryptoScheme)CryptoScheme.Sr25519, (String)password);
            Moshi moshi2 = new Moshi.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)moshi2, (String)"Builder().build()");
            Moshi moshi3 = moshi2;
            JsonAdapter jsonAdapter = moshi3.adapter(NativePairWrapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(NativePairWrapper::class.java)");
            JsonAdapter jsonAdapter2 = jsonAdapter;
            Object object = jsonAdapter2.fromJson(pairStr);
            Intrinsics.checkNotNull((Object)object);
            NativePairWrapper pairInfo = (NativePairWrapper)object;
            Pair pair2 = Pair.fromSuri((CryptoScheme)CryptoScheme.Sr25519, (String)pairInfo.getSecretSeed(), (String)password);
            Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"{\n            val pairSt\u2026Seed, password)\n        }");
            pair = pair2;
        } else {
            Pair pair3 = Pair.fromSuri((CryptoScheme)CryptoScheme.Sr25519, (String)seed, (String)password);
            pair = pair3;
            Intrinsics.checkNotNullExpressionValue((Object)pair3, (String)"{\n            Pair.fromS\u2026seed, password)\n        }");
        }
        this.pair = pair;
    }

    @Override
    @NotNull
    public String sign(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        byte[] byArray = this.pair.sign(this.toByteArray(string));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"pair.sign(toByteArray(data.substring(2)))");
        String signature2 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)sign.signature.1.INSTANCE, (int)30, null);
        return "0x01" + signature2;
    }

    @Override
    public void close() {
        this.pair.close();
    }

    @Override
    @NotNull
    public byte[] toByteArray(@NotNull String data) {
        return SignerWrapper.DefaultImpls.toByteArray(this, data);
    }
}

