/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.text.ParseException;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.clock.NetTimeConfiguration;
import net.time4j.clock.NetTimeConnector;
import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.PatternType;

public class DaytimeClock
extends NetTimeConnector<NetTimeConfiguration> {
    private static final ChronoParser<PlainDate> MJD_PARSER = ChronoFormatter.setUp(PlainDate.class, (Locale)Locale.ROOT).addPattern("ggggg", PatternType.CLDR).build();
    private static final ChronoParser<PlainTime> TIME_PARSER = ChronoFormatter.setUp(PlainTime.class, (Locale)Locale.ROOT).addPattern("HH:mm:ss", PatternType.CLDR).build();
    private static final ChronoParser<Moment> NIST_PARSER = new ChronoParser<Moment>(){

        public Moment parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
            int n = 0;
            while (!Character.isDigit(charSequence.charAt(n))) {
                ++n;
            }
            PlainDate plainDate = (PlainDate)MJD_PARSER.parse(charSequence.subSequence(n, 5 + n), parseLog, attributeQuery);
            if (plainDate != null) {
                parseLog.setPosition(0);
                PlainTime plainTime = (PlainTime)TIME_PARSER.parse(charSequence.subSequence(15 + n, 23 + n), parseLog, attributeQuery);
                if (plainTime != null) {
                    return plainDate.at(plainTime).atUTC();
                }
            }
            return null;
        }
    };
    public static final DaytimeClock NIST = new DaytimeClock("time.nist.gov", NIST_PARSER);
    private final ChronoParser<Moment> parser;

    public DaytimeClock(String string, ChronoParser<Moment> chronoParser) {
        super(new SimpleDaytimeConfiguration(string));
        if (chronoParser == null) {
            throw new NullPointerException("Missing parser for translating any server reply.");
        }
        this.parser = chronoParser;
    }

    public String getRawTimestamp() throws IOException {
        Object c = this.getNetTimeConfiguration();
        String string = c.getTimeServerAddress();
        int n = c.getTimeServerPort();
        int n2 = c.getConnectionTimeout();
        return DaytimeClock.getDaytimeReply(string, n, n2);
    }

    @Override
    protected Moment doConnect() throws ParseException, IOException {
        Object c = this.getNetTimeConfiguration();
        String string = c.getTimeServerAddress();
        int n = c.getTimeServerPort();
        int n2 = c.getConnectionTimeout();
        String string2 = DaytimeClock.getDaytimeReply(string, n, n2);
        this.log("DAYTIME-Server connected: ", string2);
        return (Moment)this.parser.parse((CharSequence)string2, new ParseLog(), Attributes.empty());
    }

    @Override
    protected Class<NetTimeConfiguration> getConfigurationType() {
        return NetTimeConfiguration.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDaytimeReply(String string, int n, int n2) throws IOException {
        IOException iOException = null;
        Socket socket = null;
        StringBuilder stringBuilder = null;
        try {
            int n3;
            socket = new Socket(string, n);
            socket.setSoTimeout(n2 * 1000);
            InputStream inputStream = socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            char[] cArray = new char[100];
            stringBuilder = new StringBuilder();
            while ((n3 = bufferedReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n3);
            }
            inputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException3) {
                System.err.println("Ignored exception while closing time server socket: " + iOException3.getMessage());
                iOException3.printStackTrace(System.err);
            }
        }
        if (iOException == null) {
            return stringBuilder.toString();
        }
        throw iOException;
    }

    private static class SimpleDaytimeConfiguration
    implements NetTimeConfiguration {
        private final String server;

        SimpleDaytimeConfiguration(String string) {
            if (string == null) {
                throw new NullPointerException("Missing time server address.");
            }
            this.server = string;
        }

        @Override
        public String getTimeServerAddress() {
            return this.server;
        }

        @Override
        public int getTimeServerPort() {
            return 13;
        }

        @Override
        public int getConnectionTimeout() {
            return 60;
        }

        @Override
        public int getClockShiftWindow() {
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SimpleDaytimeConfiguration:[server=");
            stringBuilder.append(this.server);
            stringBuilder.append(",port=");
            stringBuilder.append(this.getTimeServerPort());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

