/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;

final class SingleOffsetTimezone
extends Timezone
implements TransitionHistory {
    private static final long serialVersionUID = 7807230388259573234L;
    private final ZonalOffset offset;

    SingleOffsetTimezone(ZonalOffset zonalOffset) {
        if (zonalOffset == null) {
            throw new NullPointerException("Missing timezone offset.");
        }
        this.offset = zonalOffset;
    }

    @Override
    public TZID getID() {
        return this.offset;
    }

    @Override
    public ZonalOffset getOffset(UnixTime unixTime) {
        return this.offset;
    }

    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime) {
        return this.offset;
    }

    @Override
    public boolean isInvalid(GregorianDate gregorianDate, WallTime wallTime) {
        return false;
    }

    @Override
    public boolean isDaylightSaving(UnixTime unixTime) {
        return false;
    }

    @Override
    public TransitionHistory getHistory() {
        return this;
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return Collections.emptyList();
    }

    @Override
    public List<ZonalTransition> getStdTransitionsBefore(UnixTime unixTime) {
        return Collections.emptyList();
    }

    @Override
    public List<ZonalTransition> getStdTransitionsAfter(UnixTime unixTime) {
        return Collections.emptyList();
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        return Collections.emptyList();
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        return Collections.singletonList(this.offset);
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        return null;
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        return null;
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return this.offset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SingleOffsetTimezone) {
            SingleOffsetTimezone singleOffsetTimezone = (SingleOffsetTimezone)object;
            return this.offset.equals(singleOffsetTimezone.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.offset.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(':');
        stringBuilder.append(this.offset);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String getDisplayName(NameStyle nameStyle, Locale locale) {
        return nameStyle.isAbbreviation() ? this.offset.toString() : this.offset.canonical();
    }

    @Override
    public TransitionStrategy getStrategy() {
        return DEFAULT_CONFLICT_STRATEGY;
    }

    @Override
    public Timezone with(TransitionStrategy transitionStrategy) {
        return this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.offset == null) {
            throw new InvalidObjectException("Missing offset.");
        }
    }
}

