/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.Attributes;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.Leniency;
import net.time4j.format.NumberType;
import net.time4j.format.ParseLog;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;

final class OrdinalProcessor
implements FormatProcessor<Integer> {
    private static final Map<PluralCategory, String> ENGLISH_ORDINALS;
    private final ChronoElement<Integer> element;
    private final Map<PluralCategory, String> indicators;

    OrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = chronoElement;
        if (map == null) {
            this.indicators = null;
        } else {
            if (!map.containsKey((Object)PluralCategory.OTHER)) {
                throw new IllegalArgumentException("Missing plural category OTHER: " + map);
            }
            this.indicators = Collections.unmodifiableMap(new EnumMap<PluralCategory, String>(map));
        }
    }

    @Override
    public void print(ChronoEntity<?> chronoEntity, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        int n;
        int n2 = chronoEntity.get(this.element);
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot format negative ordinal numbers: " + chronoEntity);
        }
        String string = Integer.toString(n2);
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        if (c != '0') {
            n = c - 48;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(cArray[i] + n);
            }
            string = new String(cArray);
        }
        n = -1;
        int n3 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        n3 += string.length();
        String string2 = this.getIndicator(formatStep, attributeQuery, n2);
        appendable.append(string2);
        if (n != -1 && (n3 += string2.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n3));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        int n2;
        int n3;
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        int n4 = 1;
        int n5 = 9;
        int n6 = charSequence.length();
        int n7 = parseLog.getPosition();
        int n8 = n7;
        if (n8 >= n6) {
            parseLog.setError(n8, "Missing digits for: " + this.element.name());
            return;
        }
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        int n9 = formatStep.getReserved();
        if (n9 > 0) {
            int n10;
            n3 = 0;
            for (n2 = n8; n2 < n6 && (n10 = charSequence.charAt(n2) - c) >= 0 && n10 <= 9; ++n2) {
                ++n3;
            }
            n5 = Math.min(n5, n3 - n9);
        }
        n3 = n8 + n4;
        n2 = Math.min(n6, n8 + n5);
        long l = 0L;
        boolean bl = true;
        while (n8 < n2) {
            n = charSequence.charAt(n8) - c;
            if (n >= 0 && n <= 9) {
                l = l * 10L + (long)n;
                ++n8;
                bl = false;
                continue;
            }
            if (!bl) break;
            parseLog.setError(n7, "Digit expected.");
            return;
        }
        if (n8 < n3) {
            parseLog.setError(n7, "Not enough digits found for: " + this.element.name());
            return;
        }
        n = (int)l;
        String string = this.getIndicator(formatStep, attributeQuery, n);
        int n11 = n8 + string.length();
        if (n11 >= n6) {
            parseLog.setError(n8, "Missing or wrong ordinal indicator for: " + this.element.name());
            return;
        }
        String string2 = charSequence.subSequence(n8, n11).toString();
        if (string2.equals(string)) {
            n8 = n11;
        } else if (!leniency.isLax()) {
            parseLog.setError(n8, "Wrong ordinal indicator for: " + this.element.name() + " (expected=" + string + ", found=" + string2 + ")");
            return;
        }
        map.put(this.element, n);
        parseLog.setPosition(n8);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OrdinalProcessor) {
            OrdinalProcessor ordinalProcessor = (OrdinalProcessor)object;
            return this.element.equals(ordinalProcessor.element) && this.getIndicators().equals(ordinalProcessor.getIndicators());
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.getIndicators().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", indicators=");
        stringBuilder.append(this.getIndicators());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String getIndicator(FormatStep formatStep, AttributeQuery attributeQuery, int n) {
        Locale locale = this.isEnglish() ? Locale.ENGLISH : formatStep.getAttribute(Attributes.LOCALE, attributeQuery, Locale.ROOT);
        PluralCategory pluralCategory = PluralRules.of(locale, NumberType.ORDINALS).getCategory(n);
        if (!this.getIndicators().containsKey((Object)pluralCategory)) {
            pluralCategory = PluralCategory.OTHER;
        }
        return this.getIndicators().get((Object)pluralCategory);
    }

    private boolean isEnglish() {
        return this.indicators == null;
    }

    private Map<PluralCategory, String> getIndicators() {
        if (this.isEnglish()) {
            return ENGLISH_ORDINALS;
        }
        return this.indicators;
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new OrdinalProcessor(chronoElement, this.indicators);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    static {
        EnumMap<PluralCategory, String> enumMap = new EnumMap<PluralCategory, String>(PluralCategory.class);
        enumMap.put(PluralCategory.ONE, "st");
        enumMap.put(PluralCategory.TWO, "nd");
        enumMap.put(PluralCategory.FEW, "rd");
        enumMap.put(PluralCategory.OTHER, "th");
        ENGLISH_ORDINALS = Collections.unmodifiableMap(enumMap);
    }
}

