/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ElementRule;

public enum EpochDays implements ChronoElement<Long>
{
    UTC(2441317),
    UNIX(2440587),
    MODIFIED_JULIAN_DATE(2400000),
    EXCEL(2415019),
    ANSI(2305812),
    RATA_DIE(1721424),
    JULIAN_DAY_NUMBER(-1),
    LILIAN_DAY_NUMBER(2299159);

    private final int offset;

    private EpochDays(int n2) {
        this.offset = n2 - 2440587 - 730;
    }

    public long transform(long l, EpochDays epochDays) {
        return MathUtils.safeAdd(l, (long)(epochDays.offset - this.offset));
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public char getSymbol() {
        return this == MODIFIED_JULIAN_DATE ? (char)'g' : '\u0000';
    }

    @Override
    public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        return chronoEntity.get(this).compareTo(chronoEntity2.get(this));
    }

    @Override
    public Long getDefaultMinimum() {
        return -365243219892L - (long)this.offset;
    }

    @Override
    public Long getDefaultMaximum() {
        return 365241779741L - (long)this.offset;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    <D extends ChronoEntity<D>> ElementRule<D, Long> derive(CalendarSystem<D> calendarSystem) {
        return new Rule<D>(this, calendarSystem);
    }

    private static class Rule<D extends ChronoEntity<D>>
    implements ElementRule<D, Long> {
        private static final int UTC_OFFSET = 730;
        private final EpochDays element;
        private final CalendarSystem<D> calsys;

        Rule(EpochDays epochDays, CalendarSystem<D> calendarSystem) {
            this.element = epochDays;
            this.calsys = calendarSystem;
        }

        @Override
        public Long getValue(D d) {
            long l = this.element.transform(this.calsys.transform(d) + 730L, UNIX);
            return l;
        }

        @Override
        public boolean isValid(D d, Long l) {
            long l2 = MathUtils.safeSubtract(UNIX.transform(l, this.element), 730L);
            return l2 <= this.calsys.getMaximumSinceUTC() && l2 >= this.calsys.getMinimumSinceUTC();
        }

        @Override
        public D withValue(D d, Long l, boolean bl) {
            long l2 = MathUtils.safeSubtract(UNIX.transform(l, this.element), 730L);
            return (D)((ChronoEntity)this.calsys.transform(l2));
        }

        @Override
        public Long getMinimum(D d) {
            long l = this.element.transform(this.calsys.getMinimumSinceUTC() + 730L, UNIX);
            return l;
        }

        @Override
        public Long getMaximum(D d) {
            long l = this.element.transform(this.calsys.getMaximumSinceUTC() + 730L, UNIX);
            return l;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d) {
            return null;
        }
    }
}

