/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import net.time4j.AbstractDateElement;
import net.time4j.AdjustableElement;
import net.time4j.CalendarUnit;
import net.time4j.ElementOperator;
import net.time4j.IsoDateUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.UnitRule;
import net.time4j.format.NumericalElement;

final class YOWElement
extends AbstractDateElement<Integer>
implements AdjustableElement<Integer, PlainDate>,
NumericalElement<Integer> {
    private static final UnitRule U_RULE = new URule();
    static final YOWElement INSTANCE = new YOWElement("YEAR_OF_WEEKDATE");
    private static final long serialVersionUID = -6907291758376370420L;
    private final transient ElementOperator<PlainDate> previousAdjuster = new YOWRollingAdjuster(-1L);
    private final transient ElementOperator<PlainDate> nextAdjuster = new YOWRollingAdjuster(1L);

    private YOWElement(String string) {
        super(string);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return 'Y';
    }

    @Override
    public int numerical(Integer n) {
        return n;
    }

    @Override
    public Integer getDefaultMinimum() {
        return PlainDate.MIN_YEAR;
    }

    @Override
    public Integer getDefaultMaximum() {
        return PlainDate.MAX_YEAR;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ElementOperator<PlainDate> decremented() {
        return this.previousAdjuster;
    }

    @Override
    public ElementOperator<PlainDate> incremented() {
        return this.nextAdjuster;
    }

    static <T extends ChronoEntity<T>> ElementRule<T, Integer> elementRule(Class<T> clazz) {
        return new ERule();
    }

    private static <T extends ChronoEntity<T>> UnitRule<T> unitRule() {
        return U_RULE;
    }

    private static int getFirstCalendarWeekAsDayOfYear(PlainDate plainDate, int n) {
        return YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate.getYear() + n);
    }

    private static int getFirstCalendarWeekAsDayOfYear(int n) {
        Weekday weekday = Weekday.valueOf(GregorianMath.getDayOfWeek(n, 1, 1));
        int n2 = weekday.getValue(Weekmodel.ISO);
        return n2 <= 8 - Weekmodel.ISO.getMinimalDaysInFirstWeek() ? 2 - n2 : 9 - n2;
    }

    private static int getLengthOfYear(PlainDate plainDate, int n) {
        return GregorianMath.isLeapYear(plainDate.getYear() + n) ? 366 : 365;
    }

    private static int getWeekOfYear(PlainDate plainDate) {
        int n = plainDate.getDayOfYear();
        int n2 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 0);
        if (n2 <= n) {
            int n3;
            int n4 = (n - n2) / 7 + 1;
            if (n4 >= 53 && (n3 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 1) + YOWElement.getLengthOfYear(plainDate, 0)) <= n) {
                n4 = 1;
            }
            return n4;
        }
        int n5 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, -1);
        int n6 = n + YOWElement.getLengthOfYear(plainDate, -1);
        return (n6 - n5) / 7 + 1;
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private static class ERule<T extends ChronoEntity<T>>
    implements ElementRule<T, Integer> {
        private ERule() {
        }

        @Override
        public Integer getValue(T t) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            int n = plainDate.getYear();
            int n2 = plainDate.getDayOfYear();
            int n3 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 0);
            if (n3 <= n2) {
                int n4;
                if ((n2 - n3) / 7 + 1 >= 53 && (n4 = YOWElement.getFirstCalendarWeekAsDayOfYear(plainDate, 1) + YOWElement.getLengthOfYear(plainDate, 0)) <= n2) {
                    ++n;
                }
            } else {
                --n;
            }
            return n;
        }

        @Override
        public Integer getMinimum(T t) {
            return INSTANCE.getDefaultMinimum();
        }

        @Override
        public Integer getMaximum(T t) {
            return INSTANCE.getDefaultMaximum();
        }

        @Override
        public boolean isValid(T t, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= -999999999 && n2 <= 999999999;
        }

        @Override
        public T withValue(T t, Integer n, boolean bl) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            plainDate = ERule.setYearOfWeekdate(plainDate, n);
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t) {
            return this.getChild();
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t) {
            return this.getChild();
        }

        private ChronoElement<?> getChild() {
            return Weekmodel.ISO.weekOfYear();
        }

        private static PlainDate setYearOfWeekdate(PlainDate plainDate, int n) {
            int n2;
            int n3 = YOWElement.getFirstCalendarWeekAsDayOfYear(n);
            int n4 = YOWElement.getWeekOfYear(plainDate);
            int n5 = plainDate.getDayOfWeek().getValue(Weekmodel.ISO);
            long l = EpochDays.UNIX.transform(GregorianMath.toMJD(n, 1, 1), EpochDays.MODIFIED_JULIAN_DATE) + (long)(n3 - 1) + (long)((n4 - 1) * 7) + (long)(n5 - 1);
            if (n4 == 53 && ((n2 = YOWElement.getFirstCalendarWeekAsDayOfYear(n + 1) + (GregorianMath.isLeapYear(n) ? 366 : 365)) - n3) / 7 < 53) {
                l -= 7L;
            }
            return plainDate.withDaysSinceUTC(l - 730L);
        }
    }

    private static class URule<T extends ChronoEntity<T>>
    implements UnitRule<T> {
        private URule() {
        }

        @Override
        public T addTo(T t, long l) {
            if (l == 0L) {
                return t;
            }
            int n = MathUtils.safeCast(MathUtils.safeAdd((long)((ChronoEntity)t).get(INSTANCE).intValue(), l));
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            int n2 = plainDate.getWeekOfYear();
            Weekday weekday = plainDate.getDayOfWeek();
            if (n2 == 53) {
                PlainDate plainDate2 = PlainDate.of(n, 26, weekday);
                n2 = (Integer)plainDate2.getMaximum(Weekmodel.ISO.weekOfYear());
            }
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)PlainDate.of(n, n2, weekday));
        }

        @Override
        public long between(T t, T t2) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            PlainDate plainDate2 = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            int n = plainDate.get(INSTANCE);
            int n2 = plainDate2.get(INSTANCE);
            long l = n2 - n;
            if (l != 0L) {
                int n3 = YOWElement.getWeekOfYear(plainDate);
                int n4 = YOWElement.getWeekOfYear(plainDate2);
                if (l > 0L && n3 > n4) {
                    --l;
                } else if (l < 0L && n3 < n4) {
                    ++l;
                }
                if (l != 0L && n3 == n4) {
                    int n5 = plainDate.getDayOfWeek().getValue();
                    int n6 = plainDate2.getDayOfWeek().getValue();
                    if (l > 0L && n5 > n6) {
                        --l;
                    } else if (l < 0L && n5 < n6) {
                        ++l;
                    }
                    if (l != 0L && n5 == n6 && ((ChronoEntity)t).contains(PlainTime.WALL_TIME) && ((ChronoEntity)t2).contains(PlainTime.WALL_TIME)) {
                        PlainTime plainTime = ((ChronoEntity)t).get(PlainTime.WALL_TIME);
                        PlainTime plainTime2 = ((ChronoEntity)t2).get(PlainTime.WALL_TIME);
                        if (l > 0L && plainTime.isAfter(plainTime2)) {
                            --l;
                        } else if (l < 0L && plainTime.isBefore(plainTime2)) {
                            ++l;
                        }
                    }
                }
            }
            return l;
        }
    }

    private static class YOWRollingAdjuster
    extends ElementOperator<PlainDate> {
        private final long amount;
        private final ChronoOperator<PlainTimestamp> yowTS;

        private YOWRollingAdjuster(long l) {
            super(INSTANCE, 8);
            this.amount = l;
            this.yowTS = new ChronoOperator<PlainTimestamp>(){

                @Override
                public PlainTimestamp apply(PlainTimestamp plainTimestamp) {
                    UnitRule unitRule = YOWElement.unitRule();
                    return unitRule.addTo(plainTimestamp, YOWRollingAdjuster.this.amount);
                }
            };
        }

        @Override
        public PlainDate apply(PlainDate plainDate) {
            UnitRule unitRule = YOWElement.unitRule();
            return unitRule.addTo(plainDate, this.amount);
        }

        @Override
        ChronoOperator<PlainTimestamp> onTimestamp() {
            return this.yowTS;
        }
    }

    static enum YOWUnit implements IsoDateUnit,
    UnitRule.Source
    {
        WEEK_BASED_YEARS;


        @Override
        public char getSymbol() {
            return '\u0000';
        }

        @Override
        public double getLength() {
            return CalendarUnit.YEARS.getLength();
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        @Override
        public <T extends ChronoEntity<T>> UnitRule<T> derive(Chronology<T> chronology) {
            if (chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
                return YOWElement.unitRule();
            }
            return null;
        }
    }
}

