/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.scale.TimeScale;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public class TemporalTypes<S extends Comparable<?>, T extends ChronoEntity<T>>
extends BasicElement<S> {
    private static final boolean WITH_SQL_UTC_CONVERSION = Boolean.getBoolean("net.time4j.sql.utc.conversion");
    private static final PlainDate UNIX_DATE = PlainDate.of(0L, EpochDays.UNIX);
    private static final long serialVersionUID = 1081658250255619999L;
    private static final int MIO = 1000000;
    private static final Timestamp TIMESTAMP_MAX;
    public static final TemporalTypes<java.util.Date, Moment> JAVA_UTIL_DATE;
    public static final TemporalTypes<Long, Moment> MILLIS_SINCE_UNIX;
    public static final TemporalTypes<Date, PlainDate> SQL_DATE;
    public static final TemporalTypes<Time, PlainTime> SQL_TIME;
    public static final TemporalTypes<Timestamp, PlainTimestamp> SQL_TIMESTAMP;
    private static final Map<String, TemporalTypes<?, ?>> CACHE;
    private final transient Class<S> sourceType;
    private final transient Class<T> targetType;
    private final transient ElementRule<T, S> rule;
    private final transient Comparator<ChronoEntity<?>> comparator;
    private final transient S dmin;
    private final transient S dmax;
    private final transient boolean dateLike;
    private final transient boolean timeLike;

    protected TemporalTypes(String string, Class<S> clazz, Class<T> clazz2, ElementRule<T, S> elementRule, Comparator<ChronoEntity<?>> comparator, S s, S s2, boolean bl, boolean bl2) {
        super(string);
        if (clazz == null) {
            throw new NullPointerException("Missing source type.");
        }
        if (clazz2 == null) {
            throw new NullPointerException("Missing target type.");
        }
        if (elementRule == null) {
            throw new NullPointerException("Missing chronological rule.");
        }
        if (comparator == null) {
            throw new NullPointerException("Missing comparator.");
        }
        if (s == null) {
            throw new NullPointerException("Missing standard minimum.");
        }
        if (s2 == null) {
            throw new NullPointerException("Missing standard maximum.");
        }
        this.sourceType = clazz;
        this.targetType = clazz2;
        this.rule = elementRule;
        this.comparator = comparator;
        this.dmin = s;
        this.dmax = s2;
        this.dateLike = bl;
        this.timeLike = bl2;
    }

    @Override
    public Class<S> getType() {
        return this.sourceType;
    }

    public T transform(S s) {
        Object object = null;
        if (this.getClass() != TemporalTypes.class) {
            object = Chronology.lookup(this.targetType).createFrom((TimeSource)SystemClock.INSTANCE, (AttributeQuery)new Attributes.Builder().setStdTimezone().build());
        }
        return (T)((ChronoEntity)this.rule.withValue(object, s, this.isLenient()));
    }

    @Override
    public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        return this.comparator.compare(chronoEntity, chronoEntity2);
    }

    @Override
    public S getDefaultMinimum() {
        return this.dmin;
    }

    @Override
    public S getDefaultMaximum() {
        return this.dmax;
    }

    @Override
    public boolean isDateElement() {
        return this.dateLike;
    }

    @Override
    public boolean isTimeElement() {
        return this.timeLike;
    }

    @Override
    protected final <T extends ChronoEntity<T>> ElementRule<T, S> derive(Chronology<T> chronology) {
        if (chronology.getChronoType() == this.targetType) {
            return this.rule;
        }
        return null;
    }

    private static void fill(Map<String, TemporalTypes<?, ?>> map, TemporalTypes<?, ?> temporalTypes) {
        map.put(temporalTypes.name(), temporalTypes);
    }

    private Object readResolve() throws ObjectStreamException {
        TemporalTypes<?, ?> temporalTypes = CACHE.get(this.name());
        return temporalTypes == null ? this : temporalTypes;
    }

    static {
        Cloneable cloneable = new Timestamp(Long.MAX_VALUE);
        cloneable.setNanos(999999999);
        TIMESTAMP_MAX = cloneable;
        JAVA_UTIL_DATE = new TemporalTypes<java.util.Date, Moment>("JAVA_UTIL_DATE", java.util.Date.class, Moment.class, new JavaUtilDateRule(), new Comparator<ChronoEntity<?>>(){

            @Override
            public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
                java.util.Date date = (java.util.Date)chronoEntity.get(JAVA_UTIL_DATE);
                java.util.Date date2 = (java.util.Date)chronoEntity2.get(JAVA_UTIL_DATE);
                return date.compareTo(date2);
            }
        }, new java.util.Date(Long.MIN_VALUE), new java.util.Date(Long.MAX_VALUE), true, true);
        MILLIS_SINCE_UNIX = new TemporalTypes<Long, Moment>("MILLIS_SINCE_UNIX", Long.class, Moment.class, new MillisSinceUnixRule(), new Comparator<ChronoEntity<?>>(){

            @Override
            public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
                Long l = (Long)chronoEntity.get(MILLIS_SINCE_UNIX);
                Long l2 = (Long)chronoEntity2.get(MILLIS_SINCE_UNIX);
                return l.compareTo(l2);
            }
        }, Long.MIN_VALUE, Long.MAX_VALUE, true, true);
        SQL_DATE = new TemporalTypes<Date, PlainDate>("SQL_DATE", Date.class, PlainDate.class, new SqlDateRule(), new Comparator<ChronoEntity<?>>(){

            @Override
            public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
                return ((Date)chronoEntity.get(SQL_DATE)).compareTo((java.util.Date)chronoEntity2.get(SQL_DATE));
            }
        }, new Date(-2208988800000L), new Date(253402300799999L), true, false);
        SQL_TIME = new TemporalTypes<Time, PlainTime>("SQL_TIME", Time.class, PlainTime.class, new SqlTimeRule(), new Comparator<ChronoEntity<?>>(){

            @Override
            public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
                return ((Time)chronoEntity.get(SQL_TIME)).compareTo((java.util.Date)chronoEntity2.get(SQL_TIME));
            }
        }, new Time(((Integer)PlainTime.MILLI_OF_DAY.getDefaultMinimum()).intValue()), new Time(((Integer)PlainTime.MILLI_OF_DAY.getDefaultMaximum()).intValue()), false, true);
        SQL_TIMESTAMP = new TemporalTypes<Timestamp, PlainTimestamp>("SQL_TIMESTAMP", Timestamp.class, PlainTimestamp.class, new SqlTimestampRule(), new Comparator<ChronoEntity<?>>(){

            @Override
            public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
                Timestamp timestamp = (Timestamp)chronoEntity.get(SQL_TIMESTAMP);
                Timestamp timestamp2 = (Timestamp)chronoEntity2.get(SQL_TIMESTAMP);
                return timestamp.compareTo(timestamp2);
            }
        }, new Timestamp(Long.MIN_VALUE), TIMESTAMP_MAX, true, true);
        cloneable = new HashMap();
        TemporalTypes.fill(cloneable, JAVA_UTIL_DATE);
        TemporalTypes.fill(cloneable, MILLIS_SINCE_UNIX);
        TemporalTypes.fill(cloneable, SQL_DATE);
        TemporalTypes.fill(cloneable, SQL_TIME);
        TemporalTypes.fill(cloneable, SQL_TIMESTAMP);
        CACHE = Collections.unmodifiableMap(cloneable);
    }

    private static class SqlTimestampRule
    implements ElementRule<PlainTimestamp, Timestamp> {
        private SqlTimestampRule() {
        }

        @Override
        public Timestamp getValue(PlainTimestamp plainTimestamp) {
            Comparable<ZonalOffset> comparable;
            long l = MathUtils.safeMultiply(plainTimestamp.getCalendarDate().getDaysSinceUTC() + 730L, 86400000L);
            long l2 = ((Integer)plainTimestamp.get(PlainTime.MILLI_OF_DAY)).intValue();
            if (!WITH_SQL_UTC_CONVERSION) {
                comparable = Timezone.ofSystem().getOffset(plainTimestamp, plainTimestamp);
                l2 -= (long)(((ZonalOffset)comparable).getIntegralAmount() * 1000);
            }
            comparable = new Timestamp(MathUtils.safeAdd(l, l2));
            ((Timestamp)comparable).setNanos((Integer)plainTimestamp.get(PlainTime.NANO_OF_SECOND));
            return comparable;
        }

        @Override
        public PlainTimestamp withValue(PlainTimestamp plainTimestamp, Timestamp timestamp, boolean bl) {
            Comparable<ZonalOffset> comparable;
            TimePoint timePoint;
            long l = timestamp.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                timePoint = Moment.of(MathUtils.floorDivide(l, 1000), TimeScale.POSIX);
                comparable = Timezone.ofSystem().getOffset((UnixTime)((Object)timePoint));
                l += (long)(((ZonalOffset)comparable).getIntegralAmount() * 1000);
            }
            timePoint = PlainDate.of(MathUtils.floorDivide(l, 86400000), EpochDays.UNIX);
            comparable = PlainTime.createFromMillis(MathUtils.floorModulo(l, 86400000));
            PlainTimestamp plainTimestamp2 = PlainTimestamp.of((PlainDate)timePoint, comparable);
            return (PlainTimestamp)plainTimestamp2.with((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, timestamp.getNanos());
        }

        @Override
        public boolean isValid(PlainTimestamp plainTimestamp, Timestamp timestamp) {
            return timestamp != null;
        }

        @Override
        public Timestamp getMinimum(PlainTimestamp plainTimestamp) {
            return (Timestamp)SQL_TIMESTAMP.getDefaultMinimum();
        }

        @Override
        public Timestamp getMaximum(PlainTimestamp plainTimestamp) {
            return (Timestamp)SQL_TIMESTAMP.getDefaultMaximum();
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTimestamp plainTimestamp) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTimestamp plainTimestamp) {
            return null;
        }
    }

    private static class SqlTimeRule
    implements ElementRule<PlainTime, Time> {
        private SqlTimeRule() {
        }

        @Override
        public Time getValue(PlainTime plainTime) {
            long l = ((Integer)plainTime.get(PlainTime.MILLI_OF_DAY)).intValue();
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(UNIX_DATE, plainTime);
                l -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Time(l);
        }

        @Override
        public PlainTime withValue(PlainTime plainTime, Time time, boolean bl) {
            long l = time.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of(MathUtils.floorDivide(l, 1000), TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return (PlainTime)PlainTime.MIN.with((ChronoElement<Integer>)PlainTime.MILLI_OF_DAY, MathUtils.floorModulo(l, 86400000));
        }

        @Override
        public boolean isValid(PlainTime plainTime, Time time) {
            return time != null;
        }

        @Override
        public Time getMinimum(PlainTime plainTime) {
            return (Time)SQL_TIME.getDefaultMinimum();
        }

        @Override
        public Time getMaximum(PlainTime plainTime) {
            return (Time)SQL_TIME.getDefaultMaximum();
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainTime plainTime) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainTime plainTime) {
            return null;
        }
    }

    private static class SqlDateRule
    implements ElementRule<PlainDate, Date> {
        private SqlDateRule() {
        }

        @Override
        public Date getValue(PlainDate plainDate) {
            int n = plainDate.getYear();
            if (n < 1900 || n > 9999) {
                throw new ChronoException("SQL-Date is only defined in year range of 1900-9999.");
            }
            long l = MathUtils.safeMultiply(plainDate.getDaysSinceUTC() + 730L, 86400000L);
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(plainDate, PlainTime.MIN);
                l -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Date(l);
        }

        @Override
        public PlainDate withValue(PlainDate plainDate, Date date, boolean bl) {
            long l = date.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of(MathUtils.floorDivide(l, 1000), TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return PlainDate.axis().getCalendarSystem().transform(MathUtils.floorDivide(l, 86400000) - 730L);
        }

        @Override
        public boolean isValid(PlainDate plainDate, Date date) {
            return date != null;
        }

        @Override
        public Date getMinimum(PlainDate plainDate) {
            return (Date)SQL_DATE.getDefaultMinimum();
        }

        @Override
        public Date getMaximum(PlainDate plainDate) {
            return (Date)SQL_DATE.getDefaultMaximum();
        }

        @Override
        public ChronoElement<?> getChildAtFloor(PlainDate plainDate) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(PlainDate plainDate) {
            return null;
        }
    }

    private static class MillisSinceUnixRule
    implements ElementRule<Moment, Long> {
        private MillisSinceUnixRule() {
        }

        @Override
        public Long getValue(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            return MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
        }

        @Override
        public Moment withValue(Moment moment, Long l, boolean bl) {
            long l2 = l;
            long l3 = MathUtils.floorDivide(l2, 1000);
            int n = MathUtils.floorModulo(l2, 1000) * 1000000;
            return Moment.of(l3, n, TimeScale.POSIX);
        }

        @Override
        public boolean isValid(Moment moment, Long l) {
            return l != null;
        }

        @Override
        public Long getMinimum(Moment moment) {
            return (Long)MILLIS_SINCE_UNIX.getDefaultMinimum();
        }

        @Override
        public Long getMaximum(Moment moment) {
            return (Long)MILLIS_SINCE_UNIX.getDefaultMaximum();
        }

        @Override
        public ChronoElement<?> getChildAtFloor(Moment moment) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(Moment moment) {
            return null;
        }
    }

    private static class JavaUtilDateRule
    implements ElementRule<Moment, java.util.Date> {
        private final ElementRule<Moment, Long> rule = new MillisSinceUnixRule();

        private JavaUtilDateRule() {
        }

        @Override
        public java.util.Date getValue(Moment moment) {
            return new java.util.Date(this.rule.getValue(moment));
        }

        @Override
        public Moment withValue(Moment moment, java.util.Date date, boolean bl) {
            return this.rule.withValue(moment, date.getTime(), bl);
        }

        @Override
        public boolean isValid(Moment moment, java.util.Date date) {
            return date != null;
        }

        @Override
        public java.util.Date getMinimum(Moment moment) {
            return (java.util.Date)JAVA_UTIL_DATE.getDefaultMinimum();
        }

        @Override
        public java.util.Date getMaximum(Moment moment) {
            return (java.util.Date)JAVA_UTIL_DATE.getDefaultMaximum();
        }

        @Override
        public ChronoElement<?> getChildAtFloor(Moment moment) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(Moment moment) {
            return null;
        }
    }
}

