/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets.parts;

import java.io.DataInput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import net.tammon.sip.exceptions.TypeNotSupportedException;
import net.tammon.sip.packets.parts.Data;
import net.tammon.sip.packets.parts.DataAttribute;
import net.tammon.sip.packets.parts.DataStreamFactory;
import net.tammon.sip.packets.parts.ResponseBody;

public final class ReadOnlyDataResponseBody
implements ResponseBody {
    private static final int messageType = 72;
    private Data data;

    public ReadOnlyDataResponseBody(byte[] rawBodyData) throws IOException, TypeNotSupportedException {
        DataInput data = DataStreamFactory.getLittleEndianDataInputStream(rawBodyData);
        byte[] buffer = new byte[4];
        if (!(data instanceof FilterInputStream)) {
            throw new InvalidClassException("DataInputStream does not extend FilterInputStream. Grabbing data as byte array ist not possible!");
        }
        ((FilterInputStream)((Object)data)).read(buffer);
        DataAttribute dataAttribute = new DataAttribute(buffer);
        int lengthOfData = data.readInt();
        byte[] rawData = new byte[lengthOfData];
        ((FilterInputStream)((Object)data)).read(rawData);
        this.data = new Data(rawData, dataAttribute);
    }

    public static int getMessageType() {
        return 72;
    }

    public Data getData() {
        return this.data;
    }
}

