/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets.parts;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.tammon.sip.packets.parts.Data;

public final class Idn {
    private final byte[] eIdn;
    private final String idn;

    public Idn(String idn) {
        this.idn = idn;
        this.eIdn = Idn.getIdnAsByteArray(idn);
    }

    public Idn(byte[] eIdn) throws IOException {
        this.eIdn = eIdn;
        this.idn = Idn.getIdnAsString(eIdn);
    }

    static byte[] getIdnAsByteArray(String idn) throws IllegalArgumentException {
        if (idn.matches("^[SP]-\\d-\\d\\d\\d\\d[.]\\d[.]\\d$")) {
            byte byte1 = Byte.parseByte(idn.substring(9, 10));
            byte byte2 = Byte.parseByte(idn.substring(11));
            return Data.concatenate(new byte[][]{Idn.getIdnAs16BitByteArray(idn), Data.concatenate(byte2, byte1)});
        }
        if (idn.matches("^[SP]-\\d-\\d\\d\\d\\d$")) {
            return Data.concatenate(new byte[][]{Idn.getIdnAs16BitByteArray(idn), Data.concatenate(0, 0)});
        }
        throw new IllegalArgumentException("The specified idn is not a valid drive Parameter");
    }

    private static byte[] getIdnAs16BitByteArray(String idn) {
        byte byte3 = (byte)((Byte.parseByte(idn.substring(2, 3)) | (idn.charAt(0) == 'P' ? 8 : 0)) << 4);
        byte[] parameterNo = Data.getByteArray(Short.parseShort(idn.substring(4, 8)));
        byte3 = (byte)(byte3 | parameterNo[1]);
        byte byte4 = parameterNo[0];
        return Data.concatenate(byte4, byte3);
    }

    public static String getIdnAsString(byte[] eIdn) throws IOException {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(eIdn));
        byte[] buffer = new byte[4];
        data.read(buffer);
        char parType = (buffer[1] & 0x80) == 128 ? (char)'P' : 'S';
        int num1 = (buffer[1] & 0x70) >> 4;
        short num2 = ByteBuffer.wrap(new byte[]{(byte)(buffer[1] & 0xF), buffer[0]}).getShort();
        byte num3 = buffer[3];
        byte num4 = buffer[2];
        return "" + parType + '-' + num1 + '-' + Idn.addZerosTillLength(Integer.toString(num2), 4) + '.' + num3 + '.' + num4;
    }

    private static String addZerosTillLength(String string, int neededLength) {
        for (int length = string.length(); length < neededLength; ++length) {
            string = new StringBuilder(string).insert(0, '0').toString();
        }
        return string;
    }

    public byte[] getIdnAsByteArray() {
        return this.eIdn;
    }

    public String getIdn() {
        return this.idn;
    }
}

