/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets.parts;

import java.io.DataInput;
import java.io.IOException;
import net.tammon.sip.packets.parts.AbstractPart;
import net.tammon.sip.packets.parts.Data;
import net.tammon.sip.packets.parts.DataStreamFactory;

public final class Head
extends AbstractPart {
    private int transactionId;
    private int messageType;

    public Head(int transactionId, int messageType) {
        this.transactionId = transactionId;
        this.messageType = messageType;
    }

    public Head(byte[] rawHeadData) throws IOException {
        DataInput data = DataStreamFactory.getLittleEndianDataInputStream(rawHeadData);
        this.transactionId = data.readInt();
        this.messageType = data.readInt();
    }

    public int getMsgLength() {
        return this.getDataAsByteArray().length;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public byte[] getDataAsByteArray() {
        return Data.getByteArray(this.transactionId, this.messageType);
    }
}

