/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets.parts;

import java.io.DataInput;
import net.tammon.sip.packets.parts.AbstractBody;
import net.tammon.sip.packets.parts.CommonErrorCodes;
import net.tammon.sip.packets.parts.DataStreamFactory;
import net.tammon.sip.packets.parts.ResponseBody;

public final class ExceptionBody
extends AbstractBody
implements ResponseBody {
    private static final int messageType = 67;
    private short rawCommonErrorCode;
    private int specificErrorCode;
    private CommonErrorCodes commonErrorCode;

    public ExceptionBody(byte[] rawBodyDataArrays) throws Exception {
        DataInput data = DataStreamFactory.getLittleEndianDataInputStream(rawBodyDataArrays);
        this.rawCommonErrorCode = data.readShort();
        this.specificErrorCode = data.readInt();
        this.commonErrorCode = CommonErrorCodes.values()[this.rawCommonErrorCode - 1];
    }

    public static int getMessageType() {
        return 67;
    }

    public CommonErrorCodes getCommonErrorCode() {
        return this.commonErrorCode;
    }

    public int getSpecificErrorCode() {
        return this.specificErrorCode;
    }
}

