/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets.parts;

import java.io.DataInput;
import java.io.IOException;
import java.util.Date;
import net.tammon.sip.exceptions.TypeNotSupportedException;
import net.tammon.sip.packets.parts.DataStreamFactory;

final class DataAttribute {
    private final int weight;
    private final DataLength dataLength;
    private final boolean isList;
    private final boolean isCommand;
    private final DisplayFormat displayFormat;
    private final byte decimalPointPosition;
    private final byte rights;
    private final Class dataType;

    public DataAttribute(byte[] rawDataAttribute) throws IOException, TypeNotSupportedException {
        DataInput data = DataStreamFactory.getLittleEndianDataInputStream(rawDataAttribute);
        int rawWeight = data.readUnsignedShort();
        this.weight = rawWeight == 0 ? 1 : rawWeight;
        byte byteBuffer = data.readByte();
        this.dataLength = DataLength.values()[byteBuffer & 3];
        this.isList = (byteBuffer & 4) == 4;
        this.isCommand = (byteBuffer & 8) == 8;
        this.displayFormat = DisplayFormat.values()[(byteBuffer & 0x70) >> 4];
        byteBuffer = data.readByte();
        this.decimalPointPosition = (byte)(byteBuffer & 0xF);
        this.rights = (byte)((byteBuffer & 0xF0) >> 4);
        this.dataType = this.getJavaType(this.displayFormat, this.dataLength, this.weight, this.decimalPointPosition, this.isList);
    }

    public int getWeight() {
        return this.weight;
    }

    public DataLength getDataLength() {
        return this.dataLength;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public byte getDecimalPointPosition() {
        return this.decimalPointPosition;
    }

    public byte getRights() {
        return this.rights;
    }

    public Class getJavaType() {
        return this.dataType;
    }

    private Class getJavaType(DisplayFormat displayFormat, DataLength dataLength, int weight, byte decimalPointPosition, boolean isList) throws TypeNotSupportedException {
        switch (displayFormat) {
            case Binary: {
                switch (dataLength) {
                    case oneByte: {
                        return isList ? byte[].class : Byte.TYPE;
                    }
                }
                return isList ? byte[][].class : byte[].class;
            }
            case UnsignedDecimal: {
                switch (dataLength) {
                    case oneByte: {
                        if (decimalPointPosition == 0) {
                            return isList ? short[].class : Short.TYPE;
                        }
                        return isList ? float[].class : Float.TYPE;
                    }
                    case twoBytes: {
                        if (decimalPointPosition == 0) {
                            return isList ? int[].class : Integer.TYPE;
                        }
                        return isList ? float[].class : Float.TYPE;
                    }
                    case fourBytes: {
                        if (decimalPointPosition == 0) {
                            return isList ? long[].class : Long.TYPE;
                        }
                        return isList ? double[].class : Double.TYPE;
                    }
                    case eightBytes: {
                        throw new TypeNotSupportedException("eight byte unsigned decimal is currently not supported by this library! Sorry...");
                    }
                }
            }
            case HexaDecimal: {
                return isList ? byte[][].class : byte[].class;
            }
            case SignedDecimal: {
                switch (dataLength) {
                    case oneByte: {
                        if (decimalPointPosition == 0) {
                            return isList ? byte[].class : Byte.TYPE;
                        }
                        return isList ? float[].class : Float.TYPE;
                    }
                    case twoBytes: {
                        if (decimalPointPosition == 0) {
                            return isList ? short[].class : Short.TYPE;
                        }
                        return isList ? float[].class : Float.TYPE;
                    }
                    case fourBytes: {
                        if (decimalPointPosition == 0) {
                            return isList ? int[].class : Integer.TYPE;
                        }
                        return isList ? double[].class : Double.TYPE;
                    }
                    case eightBytes: {
                        if (decimalPointPosition == 0) {
                            return isList ? long[].class : Long.TYPE;
                        }
                        return isList ? double[].class : Double.TYPE;
                    }
                }
            }
            case String: {
                if (!dataLength.equals((Object)DataLength.oneByte)) break;
                return String.class;
            }
            case IDN: {
                if (!dataLength.equals((Object)DataLength.fourBytes)) break;
                return isList ? String[].class : String.class;
            }
            case Float: {
                return isList ? double[].class : Double.TYPE;
            }
            case SERCOSTime: {
                return isList ? Date[].class : Date.class;
            }
            default: {
                throw new IllegalArgumentException("Unknown display format! : " + (Object)((Object)displayFormat));
            }
        }
        throw new IllegalArgumentException("Invalid data length: " + (Object)((Object)dataLength) + ". Current display format: " + (Object)((Object)displayFormat));
    }

    public String toString() {
        return "weight: " + this.weight + "\nisList: " + this.isList + "\nisCommand: " + this.isCommand + "\nDataLength: " + (Object)((Object)this.dataLength) + "\nDisplay Format: " + (Object)((Object)this.displayFormat) + "\nDecimal Point Position: " + this.decimalPointPosition + "\nRights: " + this.rights;
    }

    public static enum Type {
        Empty,
        Object,
        DBNull,
        Boolean,
        Char,
        SByte,
        Byte,
        Int16,
        UInt16,
        Int32,
        UInt32,
        Int64,
        UInt64,
        Single,
        Double,
        Decimal,
        DateTime,
        notApplicableType,
        String;

    }

    public static enum DisplayFormat {
        Binary,
        UnsignedDecimal,
        SignedDecimal,
        HexaDecimal,
        String,
        IDN,
        Float,
        SERCOSTime,
        StructuredNode,
        Undefined;


        public boolean equalsAny(DisplayFormat ... displayFormats) {
            for (DisplayFormat displayFormat : displayFormats) {
                if (!this.equals((Object)displayFormat)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum DataLength {
        oneByte(1),
        twoBytes(2),
        fourBytes(4),
        eightBytes(8);

        private int value;

        private DataLength(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

