/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets.parts;

import java.io.DataInput;
import java.io.IOException;
import net.tammon.sip.packets.parts.AbstractBody;
import net.tammon.sip.packets.parts.DataStreamFactory;
import net.tammon.sip.packets.parts.ResponseBody;

public final class ConnectResponseBody
extends AbstractBody
implements ResponseBody {
    private static final int messageType = 64;
    private int sipVersion;
    private int busyTimeout;
    private int leaseTimeout;
    private int noSupportedMessageTypes;
    private int[] supportedMessageTypes;

    public ConnectResponseBody(int sipVersion, int busyTimeout, int leaseTimeout, int noSupportedMessageTypes, int[] supportedMessageTypes) {
        this.sipVersion = sipVersion;
        this.busyTimeout = busyTimeout;
        this.leaseTimeout = leaseTimeout;
        this.noSupportedMessageTypes = noSupportedMessageTypes;
        this.supportedMessageTypes = supportedMessageTypes;
    }

    public ConnectResponseBody(byte[] rawBodyData) throws IllegalArgumentException, IOException {
        DataInput data = DataStreamFactory.getLittleEndianDataInputStream(rawBodyData);
        this.sipVersion = data.readInt();
        this.busyTimeout = data.readInt();
        this.leaseTimeout = data.readInt();
        this.noSupportedMessageTypes = data.readInt();
        this.supportedMessageTypes = new int[this.noSupportedMessageTypes];
        for (int i = 0; i < this.noSupportedMessageTypes; ++i) {
            try {
                this.supportedMessageTypes[i] = data.readInt();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getMessageType() {
        return 64;
    }

    public int getSipVersion() {
        return this.sipVersion;
    }

    public int getBusyTimeout() {
        return this.busyTimeout;
    }

    public int getLeaseTimeout() {
        return this.leaseTimeout;
    }

    public int getNoSupportedMessageTypes() {
        return this.noSupportedMessageTypes;
    }

    public int[] getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }
}

