/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip.packets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.tammon.sip.packets.AbstractPacket;
import net.tammon.sip.packets.Request;
import net.tammon.sip.packets.parts.Head;
import net.tammon.sip.packets.parts.RequestBody;

abstract class AbstractRequestPacket
extends AbstractPacket
implements Request {
    protected RequestBody body;

    public AbstractRequestPacket(int transactionId, RequestBody requestBody) {
        this.head = new Head(transactionId, requestBody.getMessageType());
        this.body = requestBody;
    }

    public AbstractRequestPacket(int transactionId, int messageType) {
        this.head = new Head(transactionId, messageType);
    }

    @Override
    public byte[] getTcpMsgAsByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(this.head.getDataAsByteArray());
            out.write(this.body.getDataAsByteArray());
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

