/*
 * Decompiled with CFR 0.152.
 */
package net.tammon.sip;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.tammon.sip.SipConnection;
import net.tammon.sip.packets.Connect;
import net.tammon.sip.packets.ConnectResponse;
import net.tammon.sip.packets.ExceptionResponse;
import net.tammon.sip.packets.Ping;
import net.tammon.sip.packets.Pong;
import net.tammon.sip.packets.ReadOnlyData;
import net.tammon.sip.packets.ReadOnlyDataResponse;
import net.tammon.sip.packets.Request;
import net.tammon.sip.packets.Response;
import net.tammon.sip.packets.parts.CommonErrorCodes;
import net.tammon.sip.packets.parts.Head;

public class TCPConnection
implements SipConnection {
    private InetAddress ipAddress;
    private int maxDelay;
    private int leaseTimeout;
    private int busyTimeout;
    private int sipPort;
    private int sipVersion;
    private int transactionId = 0;
    private boolean connected = false;
    private List<Integer> supportedMessages;
    private Socket socketConnection;
    private DataOutputStream dataOutputStream;
    private DataInputStream dataInputStream;
    private Timer keepAliveTimer;

    public TCPConnection(String host, boolean keepAlive) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("sipDefault.properties");
        Properties properties = new Properties();
        properties.load(inputStream);
        this.sipPort = new Integer(properties.getProperty("sipPort"));
        this.ipAddress = InetAddress.getByName(host == null ? properties.getProperty("driveIp") : host);
        this.leaseTimeout = new Integer(properties.getProperty("leaseTimeout"));
        this.busyTimeout = new Integer(properties.getProperty("busyTimeout"));
        this.maxDelay = new Integer(properties.getProperty("maxDelay"));
        this.sipVersion = new Integer(properties.getProperty("sipVersion"));
        this.refreshSocketConnection();
        this.connectSip();
        if (keepAlive) {
            this.restartKeepAliveTimer();
        }
    }

    public TCPConnection() throws Exception {
        this(null, false);
    }

    public TCPConnection(String host) throws Exception {
        this(host, false);
    }

    private synchronized void refreshSocketConnection() throws Exception {
        this.transactionId = 0;
        this.socketConnection = new Socket();
        try {
            this.socketConnection.connect(new InetSocketAddress(this.ipAddress, this.sipPort), this.leaseTimeout);
            this.dataOutputStream = new DataOutputStream(this.socketConnection.getOutputStream());
            this.dataInputStream = new DataInputStream(this.socketConnection.getInputStream());
            this.supportedMessages = null;
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException("Drive does not respond to socket request. Probably wrong IP or not on network...");
        }
    }

    private synchronized int getNewTransactionId() {
        return this.transactionId++;
    }

    private synchronized Response tcpSendAndReceive(Request request, Response response) throws Exception {
        int readLength;
        if (!Objects.isNull(this.supportedMessages) && !this.supportedMessages.contains(request.getPacketHead().getMessageType())) {
            throw new UnknownServiceException("The requested operation " + request.getClass().getSimpleName() + " is not in the drive's list of supported messages");
        }
        this.dataOutputStream.write(request.getTcpMsgAsByteArray());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        do {
            readLength = this.dataInputStream.read(buffer);
            outputStream.write(buffer, 0, readLength + 1);
        } while (readLength >= 1024);
        byte[] rawResponse = outputStream.toByteArray();
        Head header = new Head(rawResponse);
        if (header.getTransactionId() != request.getTransactionId()) {
            throw new Exception("The response transaction ID " + header.getTransactionId() + " doesn't match the request transaction ID " + request.getTransactionId());
        }
        if (header.getMessageType() == 67) {
            this.refreshSocketConnection();
            ExceptionResponse exceptionResponse = new ExceptionResponse(rawResponse);
            if (exceptionResponse.getPacketBody().getCommonErrorCode() == CommonErrorCodes.UNKNOWN_MESSAGE_TYPE) {
                throw new UnknownServiceException("Message type not supported: Drive does not support the requested operation " + request.getClass().getSimpleName());
            }
            throw new ProtocolException("Drive threw Communication Exception." + (exceptionResponse.getPacketBody().getCommonErrorCode() == CommonErrorCodes.SERVICESPECIFIC ? " SIP-SpecificErrorCode: " + exceptionResponse.getPacketBody().getSpecificErrorCode() : " SIP-CommonErrorCode: " + (Object)((Object)exceptionResponse.getPacketBody().getCommonErrorCode())));
        }
        if (header.getMessageType() == response.getMessageType()) {
            response.setData(rawResponse);
            return response;
        }
        throw new Exception("Invalid Message Type Response");
    }

    private void connectSip() throws Exception {
        Connect request = new Connect(this.getNewTransactionId(), this.sipVersion, this.busyTimeout, this.leaseTimeout);
        ConnectResponse response = (ConnectResponse)this.tcpSendAndReceive(request, new ConnectResponse());
        this.supportedMessages = IntStream.of(response.getPacketBody().getSupportedMessageTypes()).boxed().collect(Collectors.toList());
        this.connected = true;
    }

    private boolean respondsToPing() {
        Ping ping = new Ping(this.getNewTransactionId());
        try {
            this.tcpSendAndReceive(ping, new Pong());
            return true;
        }
        catch (SocketTimeoutException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String readDataAsString(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toString();
    }

    @Override
    public byte readDataAsByte(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toByte();
    }

    @Override
    public short readDataAsShort(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toShort();
    }

    @Override
    public int readDataAsInt(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toInt();
    }

    @Override
    public long readDataAsLong(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toLong();
    }

    @Override
    public float readDataAsFloat(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toFloat();
    }

    @Override
    public double readDataAsDouble(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toDouble();
    }

    @Override
    public byte[] readDataAsByteArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toByteArray();
    }

    @Override
    public short[] readDataAsShortArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toShortArray();
    }

    @Override
    public int[] readDataAsIntArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toIntArray();
    }

    @Override
    public long[] readDataAsLongArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toLongArray();
    }

    @Override
    public float[] readDataAsFloatArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toFloatArray();
    }

    @Override
    public double[] readDataAsDoubleArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().toDoubleArray();
    }

    @Override
    public byte[] readDataAsRawByteArray(int slaveIndex, int slaveExtension, String idn) throws Exception {
        return this.readData(slaveIndex, slaveExtension, idn).getPacketBody().getData().getRawData();
    }

    private ReadOnlyDataResponse readData(int slaveIndex, int slaveExtension, String idn) throws Exception {
        ReadOnlyData request = new ReadOnlyData(this.getNewTransactionId(), (short)slaveIndex, (short)slaveExtension, idn);
        return (ReadOnlyDataResponse)this.tcpSendAndReceive(request, new ReadOnlyDataResponse());
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.socketConnection.isConnected();
    }

    @Override
    public List<Integer> getSupportedMessages() {
        return this.supportedMessages;
    }

    @Override
    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public int getSipPort() {
        return this.sipPort;
    }

    @Override
    public int getSipVersion() {
        return this.sipVersion;
    }

    private void restartKeepAliveTimer() {
        this.keepAliveTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                TCPConnection.this.respondsToPing();
            }
        };
        this.keepAliveTimer.schedule(timerTask, Math.round((double)this.leaseTimeout * 0.7));
    }

    public void disconnect() {
        try {
            this.keepAliveTimer.cancel();
            this.keepAliveTimer.purge();
            this.socketConnection.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

