/*
 * Decompiled with CFR 0.152.
 */
package sparkdeployer;

import com.typesafe.config.Config;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.slf4s.Logger;
import org.slf4s.Logging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkdeployer.ClusterConf;
import sparkdeployer.EC2Machines;
import sparkdeployer.Machine;
import sparkdeployer.Machines;
import sparkdeployer.Master$;
import sparkdeployer.OSMachines;
import sparkdeployer.SSH;
import sparkdeployer.SSH$;
import sparkdeployer.SparkDeployer$;
import sparkdeployer.SparkDeployer$$anonfun$addWorkers$1$;
import sparkdeployer.SparkDeployer$$anonfun$submitJob$1$;
import sparkdeployer.Worker$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0001\u0003\u0001\u0015\u0011Qb\u00159be.$U\r\u001d7ps\u0016\u0014(\"A\u0002\u0002\u001bM\u0004\u0018M]6eKBdw._3s\u0007\u0001\u00192\u0001\u0001\u0004\r!\t9!\"D\u0001\t\u0015\u0005I\u0011!B:dC2\f\u0017BA\u0006\t\u0005\u0019\te.\u001f*fMB\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0006g24Gg\u001d\u0006\u0002#\u0005\u0019qN]4\n\u0005Mq!a\u0002'pO\u001eLgn\u001a\u0005\t+\u0001\u0011)\u0019!C\u0001-\u000511m\u001c8gS\u001e,\u0012a\u0006\t\u00031yi\u0011!\u0007\u0006\u0003+iQ!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u001a\u0005\u0019\u0019uN\u001c4jO\"A\u0011\u0005\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\t)s\u0005\u0005\u0002'\u00015\t!\u0001C\u0003\u0016E\u0001\u0007q\u0003C\u0004*\u0001\t\u0007I1\u0001\u0016\u0002\u0017\rdWo\u001d;fe\u000e{gNZ\u000b\u0002WA\u0011a\u0005L\u0005\u0003[\t\u00111b\u00117vgR,'oQ8oM\"1q\u0006\u0001Q\u0001\n-\nAb\u00197vgR,'oQ8oM\u0002Bq!\r\u0001C\u0002\u0013\r!'\u0001\u0002fGV\t1\u0007\u0005\u00025o5\tQG\u0003\u00027\u0011\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005a*$aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\"1!\b\u0001Q\u0001\nM\n1!Z2!\u0011\u001da\u0004A1A\u0005\nu\n!\"\\1ti\u0016\u0014h*Y7f+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u0003\u0011a\u0017M\\4\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u0007'R\u0014\u0018N\\4\t\r\u001d\u0003\u0001\u0015!\u0003?\u0003-i\u0017m\u001d;fe:\u000bW.\u001a\u0011\t\u000f%\u0003!\u0019!C\u0005{\u0005aqo\u001c:lKJ\u0004&/\u001a4jq\"11\n\u0001Q\u0001\ny\nQb^8sW\u0016\u0014\bK]3gSb\u0004\u0003bB'\u0001\u0005\u0004%IAT\u0001\t[\u0006\u001c\u0007.\u001b8fgV\tq\n\u0005\u0002'!&\u0011\u0011K\u0001\u0002\t\u001b\u0006\u001c\u0007.\u001b8fg\"11\u000b\u0001Q\u0001\n=\u000b\u0011\"\\1dQ&tWm\u001d\u0011\t\u000bU\u0003A\u0011\u0001,\u0002\u0019\u001d,G/T1ti\u0016\u0014x\n\u001d;\u0015\u0003]\u00032a\u0002-[\u0013\tI\u0006B\u0001\u0004PaRLwN\u001c\t\u0003MmK!\u0001\u0018\u0002\u0003\u000f5\u000b7\r[5oK\")a\f\u0001C\u0001?\u0006Qq-\u001a;X_J\\WM]:\u0015\u0003\u0001\u00042!\u00193[\u001b\u0005\u0011'BA2\t\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003K\n\u00141aU3r\u0011\u00159\u0007\u0001\"\u0003i\u00035!wn\u001e8m_\u0006$7\u000b]1sWR\u0011\u0011\u000e\u001c\t\u0003\u000f)L!a\u001b\u0005\u0003\u0007\u0005s\u0017\u0010C\u0003nM\u0002\u0007!,A\u0004nC\u000eD\u0017N\\3\t\u000b=\u0004A\u0011\u00029\u0002\u001bM,G/\u001e9Ta\u0006\u00148.\u00128w)\r\tH/\u001e\t\u0003\u000fIL!a\u001d\u0005\u0003\u0007%sG\u000fC\u0003n]\u0002\u0007!\fC\u0003w]\u0002\u0007q/\u0001\tnCN$XM]!eIJ,7o](qiB\u0019q\u0001\u0017=\u0011\u0005edhBA\u0004{\u0013\tY\b\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000bvT!a\u001f\u0005\t\r}\u0004A\u0011BA\u0001\u00031\u0011XO\\*qCJ\\7KY5o)\u001d\t\u00181AA\u0003\u0003\u0013AQ!\u001c@A\u0002iCa!a\u0002\u007f\u0001\u0004A\u0018AC:de&\u0004HOT1nK\"I\u00111\u0002@\u0011\u0002\u0003\u0007\u0011QB\u0001\u0005CJ<7\u000fE\u0003\u0002\u0010\u0005}\u0001P\u0004\u0003\u0002\u0012\u0005ma\u0002BA\n\u00033i!!!\u0006\u000b\u0007\u0005]A!\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0019\u0011Q\u0004\u0005\u0002\u000fA\f7m[1hK&\u0019Q-!\t\u000b\u0007\u0005u\u0001\u0002C\u0004\u0002&\u0001!I!a\n\u0002\u0013\u0005$G\rS8ti&\u0003HcA9\u0002*!1Q.a\tA\u0002iCq!!\f\u0001\t\u0013\ty#\u0001\tsk:\u001cF/\u0019:ukB\u001c6M]5qiR!\u0011\u0011GA\u001c!\r9\u00111G\u0005\u0004\u0003kA!\u0001B+oSRDa!\\A\u0016\u0001\u0004Q\u0006bBA\u001e\u0001\u0011%\u0011QH\u0001\ro&$\bNR1jY>4XM]\u000b\u0005\u0003\u007f\t)\u0005\u0006\u0003\u0002B\u0005E\u0003\u0003BA\"\u0003\u000bb\u0001\u0001\u0002\u0005\u0002H\u0005e\"\u0019AA%\u0005\u0005!\u0016cAA&SB\u0019q!!\u0014\n\u0007\u0005=\u0003BA\u0004O_RD\u0017N\\4\t\u0013\u0005M\u0013\u0011\bCA\u0002\u0005U\u0013AA8q!\u00159\u0011qKA!\u0013\r\tI\u0006\u0003\u0002\ty\tLh.Y7f}!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013\u0001D2sK\u0006$X-T1ti\u0016\u0014HCAA\u0019\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003K\n!\"\u00193e/>\u00148.\u001a:t)\u0011\t9'!\u001b\u0011\t\u0005$\u0017\u0011\u0007\u0005\b\u0003W\n\t\u00071\u0001r\u0003\rqW/\u001c\u0005\b\u0003_\u0002A\u0011AA9\u00035\u0019'/Z1uK\u000ecWo\u001d;feR!\u0011qMA:\u0011\u001d\tY'!\u001cA\u0002EDq!a\u001e\u0001\t\u0003\ty&\u0001\bsKN$\u0018M\u001d;DYV\u001cH/\u001a:\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\u0005i!/Z7pm\u0016<vN]6feN$B!!\r\u0002\u0000!9\u00111NA=\u0001\u0004\t\bbBAB\u0001\u0011\u0005\u0011qL\u0001\u000fI\u0016\u001cHO]8z\u00072,8\u000f^3s\u0011\u001d\t9\t\u0001C\u0001\u0003?\nAb\u001d5po6\u000b7\r[5oKNDq!a#\u0001\t\u0003\ti)A\u0005va2|\u0017\r\u001a&beR!\u0011\u0011GAH\u0011!\t\t*!#A\u0002\u0005M\u0015a\u00016beB!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a\n\u000b!![8\n\t\u0005u\u0015q\u0013\u0002\u0005\r&dW\rC\u0004\u0002\"\u0002!\t!a)\u0002\u0013M,(-\\5u\u0015>\u0014G\u0003CA\u0019\u0003K\u000b9+!+\t\u0011\u0005E\u0015q\u0014a\u0001\u0003'C\u0001\"a\u0003\u0002 \u0002\u0007\u0011Q\u0002\u0005\n\u0003W\u000by\n%AA\u0002a\f\u0011\"\\1j]\u000ec\u0017m]:\t\u0013\u0005=\u0006!%A\u0005\n\u0005E\u0016A\u0006:v]N\u0003\u0018M]6TE&tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M&\u0006BA\u0007\u0003k[#!a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003D\u0011AC1o]>$\u0018\r^5p]&!\u0011QYA^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0013\u0004\u0011\u0013!C\u0001\u0003\u0017\f1c];c[&$(j\u001c2%I\u00164\u0017-\u001e7uIM*\"!!4+\u0007a\f)lB\u0004\u0002R\nA\t!a5\u0002\u001bM\u0003\u0018M]6EKBdw._3s!\r1\u0013Q\u001b\u0004\u0007\u0003\tA\t!a6\u0014\u0007\u0005Ug\u0001C\u0004$\u0003+$\t!a7\u0015\u0005\u0005M\u0007\u0002CAp\u0003+$\t!!9\u0002\u0015\u0019\u0014x.\\\"p]\u001aLw\rF\u0002&\u0003GDa!FAo\u0001\u00049\u0002\u0002CAt\u0003+$\t!!;\u0002\u0011\u0019\u0014x.\u001c$jY\u0016$2!JAv\u0011!\ti/!:A\u0002\u0005M\u0015AC2p]\u001aLwMR5mK\"A\u0011q]Ak\t\u0003\t\t\u0010F\u0002&\u0003gDq!!>\u0002p\u0002\u0007\u00010\u0001\u0006d_:4\u0017n\u001a)bi\"\u0004")
public class SparkDeployer
implements Logging {
    private final Config config;
    private final ClusterConf clusterConf;
    private final ExecutionContextExecutorService ec;
    private final String sparkdeployer$SparkDeployer$$masterName;
    private final String sparkdeployer$SparkDeployer$$workerPrefix;
    private final Machines sparkdeployer$SparkDeployer$$machines;
    private final Logger log;

    public static SparkDeployer fromFile(String string) {
        return SparkDeployer$.MODULE$.fromFile(string);
    }

    public static SparkDeployer fromFile(File file) {
        return SparkDeployer$.MODULE$.fromFile(file);
    }

    public static SparkDeployer fromConfig(Config config) {
        return SparkDeployer$.MODULE$.fromConfig(config);
    }

    public Logger log() {
        return this.log;
    }

    public void org$slf4s$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public Config config() {
        return this.config;
    }

    public ClusterConf clusterConf() {
        return this.clusterConf;
    }

    public ExecutionContextExecutorService ec() {
        return this.ec;
    }

    public String sparkdeployer$SparkDeployer$$masterName() {
        return this.sparkdeployer$SparkDeployer$$masterName;
    }

    public String sparkdeployer$SparkDeployer$$workerPrefix() {
        return this.sparkdeployer$SparkDeployer$$workerPrefix;
    }

    public Machines sparkdeployer$SparkDeployer$$machines() {
        return this.sparkdeployer$SparkDeployer$$machines;
    }

    public Option<Machine> getMasterOpt() {
        return this.sparkdeployer$SparkDeployer$$machines().getMachines().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeployer $outer;

            public final boolean apply(Machine x$1) {
                String string = x$1.name();
                String string2 = this.$outer.sparkdeployer$SparkDeployer$$masterName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<Machine> getWorkers() {
        return (Seq)this.sparkdeployer$SparkDeployer$$machines().getMachines().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeployer $outer;

            public final boolean apply(Machine x$2) {
                return x$2.name().startsWith(this.$outer.sparkdeployer$SparkDeployer$$workerPrefix());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Object sparkdeployer$SparkDeployer$$downloadSpark(Machine machine) {
        Object object;
        String extractCmd = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tar -zxf ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterConf().sparkTgzName()}));
        if (this.clusterConf().sparkTgzUrl().startsWith("s3://")) {
            String s3Cmd = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws", "s3", "cp", "--only-show-errors", this.clusterConf().sparkTgzUrl(), "./"}))).mkString(" ");
            object = new SSH(machine.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).withRemoteCommand(new StringBuilder().append((Object)s3Cmd).append((Object)" && ").append((Object)extractCmd).toString()).withAWSCredentials();
        } else {
            object = BoxesRunTime.boxToInteger((int)new SSH(machine.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).withRemoteCommand(new StringBuilder().append((Object)"wget -nv ").append((Object)this.clusterConf().sparkTgzUrl()).append((Object)" && ").append((Object)extractCmd).toString()).withRetry().withRunningMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Downloading Spark."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name()}))).withErrorMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Failed downloading Spark."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name()}))).run());
        }
        return object;
    }

    public int sparkdeployer$SparkDeployer$$setupSparkEnv(Machine machine, Option<String> masterAddressOpt) {
        String sparkEnvPath = new StringBuilder().append((Object)this.clusterConf().sparkDirName()).append((Object)"/conf/spark-env.sh").toString();
        String masterAddress = (String)masterAddressOpt.getOrElse((Function0)new Serializable(this, machine){
            public static final long serialVersionUID = 0L;
            private final Machine machine$1;

            public final String apply() {
                return this.machine$1.address();
            }
            {
                this.machine$1 = machine$1;
            }
        });
        String sparkEnvConf = ((TraversableOnce)this.clusterConf().sparkEnv().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_MASTER_IP=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{masterAddress})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_PUBLIC_DNS=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.address()})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SPARK_LOCAL_IP=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.address()}))})), Seq$.MODULE$.canBuildFrom())).mkString("\\n");
        return new SSH(machine.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).withRemoteCommand(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"echo -e '", "' > ", " && chmod u+x ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkEnvConf, sparkEnvPath, sparkEnvPath}))).withRetry().withRunningMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Setting spark-env."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name()}))).withErrorMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Failed setting spark-env."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name()}))).run();
    }

    public int sparkdeployer$SparkDeployer$$runSparkSbin(Machine machine, String scriptName, Seq<String> args) {
        return new SSH(machine.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).withRemoteCommand(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"./", "/sbin/", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterConf().sparkDirName(), scriptName, args.mkString(" ")}))).withRetry().withRunningMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name(), scriptName}))).withErrorMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Failed on ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name(), scriptName}))).run();
    }

    public Seq<String> sparkdeployer$SparkDeployer$$runSparkSbin$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public int sparkdeployer$SparkDeployer$$addHostIp(Machine machine) {
        return new SSH(machine.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).withRemoteCommand(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"echo ", " `hostname` | sudo tee -a /etc/hosts"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.address()}))).withRetry().withRunningMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Add host ip."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{machine.name()}))).withTTY().run();
    }

    public void sparkdeployer$SparkDeployer$$runStartupScript(Machine machine) {
        this.clusterConf().startupScript().foreach((Function1)new Serializable(this, machine){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeployer $outer;
            private final Machine machine$2;

            public final int apply(String script) {
                return new SSH(this.machine$2.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.$outer.clusterConf()).withRemoteCommand(script).withRunningMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Running startup script."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.machine$2.name()}))).withTTY().run();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.machine$2 = machine$2;
            }
        });
    }

    private <T> T withFailover(Function0<T> op) {
        Try try_ = Try$.MODULE$.apply(op);
        if (try_ instanceof Success) {
            Object x;
            Success success = (Success)try_;
            Object object = x = success.value();
            return (T)object;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.clusterConf().destroyOnFail()) {
                this.destroyCluster();
            }
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public void createMaster() {
        this.withFailover((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeployer $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.getMasterOpt().isEmpty(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createMaster$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Master already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$masterName()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Machine master = this.$outer.sparkdeployer$SparkDeployer$$machines().createMachine(Master$.MODULE$, this.$outer.sparkdeployer$SparkDeployer$$masterName());
                this.$outer.sparkdeployer$SparkDeployer$$downloadSpark(master);
                Object object = this.$outer.clusterConf().enableS3A() ? BoxesRunTime.boxToInteger((int)new SSH(master.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.$outer.clusterConf()).withRemoteCommand(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wget", "-nv", "https://repo1.maven.org/maven2/com/amazonaws/aws-java-sdk/1.7.4/aws-java-sdk-1.7.4.jar", "&&", "wget", "-nv", "https://repo1.maven.org/maven2/org/apache/hadoop/hadoop-aws/2.7.1/hadoop-aws-2.7.1.jar"}))).mkString(" ")).withRetry().withRunningMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Downloading s3a jars."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkdeployer$SparkDeployer$$masterName()}))).withErrorMessage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Failed downloading s3a jars."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkdeployer$SparkDeployer$$masterName()}))).run()) : BoxedUnit.UNIT;
                this.$outer.sparkdeployer$SparkDeployer$$setupSparkEnv(master, (Option<String>)None$.MODULE$);
                Object object2 = this.$outer.clusterConf().addHostIp() ? BoxesRunTime.boxToInteger((int)this.$outer.sparkdeployer$SparkDeployer$$addHostIp(master)) : BoxedUnit.UNIT;
                this.$outer.sparkdeployer$SparkDeployer$$runStartupScript(master);
                this.$outer.sparkdeployer$SparkDeployer$$runSparkSbin(master, "start-master.sh", this.$outer.sparkdeployer$SparkDeployer$$runSparkSbin$default$3());
                if (this.$outer.log().underlying().isInfoEnabled()) {
                    this.$outer.log().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Master started."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkdeployer$SparkDeployer$$masterName()})));
                }
            }

            public /* synthetic */ SparkDeployer sparkdeployer$SparkDeployer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<BoxedUnit> addWorkers(int num) {
        return (Seq)this.withFailover((Function0)new Serializable(this, num){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeployer $outer;
            private final int num$1;

            public final Seq<BoxedUnit> apply() {
                String masterAddress = (String)this.$outer.getMasterOpt().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Machine x$3) {
                        return x$3.address();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        return package$.MODULE$.error("Master does not exist, can't create workers.");
                    }
                });
                int startIndex = BoxesRunTime.unboxToInt((Object)((TraversableLike)((SeqLike)((SeqLike)((TraversableLike)this.$outer.getWorkers().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Machine x$4) {
                        return x$4.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$5) {
                        return new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])x$5.split("-")).last())).toInt();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$)).reverse()).headOption().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                })) + 1;
                Set names = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(startIndex), startIndex + this.num$1 - 1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addWorkers$1 $outer;

                    public final String apply(int x$6) {
                        return new StringBuilder().append((Object)this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$workerPrefix()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)x$6)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
                Seq<Machine> workers = this.$outer.sparkdeployer$SparkDeployer$$machines().createMachines(Worker$.MODULE$, (Set<String>)names);
                Seq futures = (Seq)workers.map((Function1)new Serializable(this, masterAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addWorkers$1 $outer;
                    public final String masterAddress$1;

                    public final Future<BoxedUnit> apply(Machine worker) {
                        return Future$.MODULE$.apply((Function0)new Serializable(this, worker){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$addWorkers$1$$anonfun$8 $outer;
                            private final Machine worker$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$downloadSpark(this.worker$1);
                                this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$setupSparkEnv(this.worker$1, (Option<String>)new Some((Object)this.$outer.masterAddress$1));
                                Object object = this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().addHostIp() ? BoxesRunTime.boxToInteger((int)this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$addHostIp(this.worker$1)) : BoxedUnit.UNIT;
                                this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$runStartupScript(this.worker$1);
                                this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().sparkdeployer$SparkDeployer$$runSparkSbin(this.worker$1, "start-slave.sh", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark://", ":7077"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.masterAddress$1}))}))));
                                if (this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().log().underlying().isInfoEnabled()) {
                                    this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().log().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Worker started."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.worker$1.name()})));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.worker$1 = worker$1;
                            }
                        }, (ExecutionContext)this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().ec()).recover((PartialFunction)new Serializable(this, worker){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$addWorkers$1$$anonfun$8 $outer;
                            private final Machine worker$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof Exception) {
                                    Exception exception = (Exception)A1;
                                    if (this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().log().underlying().isErrorEnabled()) {
                                        this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().log().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "] Failed on setting up worker."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.worker$1.name()})), (Throwable)exception);
                                    }
                                    throw exception;
                                }
                                Object object = function1.apply(x1);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable = x1;
                                boolean bl = throwable instanceof Exception;
                                return bl;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.worker$1 = worker$1;
                            }
                        }, (ExecutionContext)this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().ec());
                    }

                    public /* synthetic */ $anonfun$addWorkers$1 sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.masterAddress$1 = masterAddress$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return (Seq)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.$outer.ec()), (Duration)Duration$.MODULE$.Inf());
            }

            public /* synthetic */ SparkDeployer sparkdeployer$SparkDeployer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.num$1 = num$1;
            }
        });
    }

    public Seq<BoxedUnit> createCluster(int num) {
        this.createMaster();
        return this.addWorkers(num);
    }

    public void restartCluster() {
        Option<Machine> option = this.getMasterOpt();
        None$ none$ = None$.MODULE$;
        Option<Machine> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw package$.MODULE$.error("Master does not exist, can't reload cluster.");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Machine master = (Machine)some.x();
            ((IterableLike)this.getWorkers().$colon$plus((Object)master, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, master){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkDeployer $outer;
                private final Machine master$1;

                public final int apply(Machine machine) {
                    return this.$outer.sparkdeployer$SparkDeployer$$setupSparkEnv(machine, (Option<String>)new Some((Object)this.master$1.address()));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.master$1 = master$1;
                }
            });
            this.getWorkers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkDeployer $outer;

                public final int apply(Machine worker) {
                    return this.$outer.sparkdeployer$SparkDeployer$$runSparkSbin(worker, "stop-slave.sh", this.$outer.sparkdeployer$SparkDeployer$$runSparkSbin$default$3());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.sparkdeployer$SparkDeployer$$runSparkSbin(master, "stop-master.sh", this.sparkdeployer$SparkDeployer$$runSparkSbin$default$3());
            this.sparkdeployer$SparkDeployer$$runSparkSbin(master, "start-master.sh", this.sparkdeployer$SparkDeployer$$runSparkSbin$default$3());
            this.getWorkers().foreach((Function1)new Serializable(this, master){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkDeployer $outer;
                private final Machine master$1;

                public final int apply(Machine worker) {
                    return this.$outer.sparkdeployer$SparkDeployer$$runSparkSbin(worker, "start-slave.sh", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark://", ":7077"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.master$1.address()}))}))));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.master$1 = master$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(option);
    }

    public void removeWorkers(int num) {
        Seq workers = (Seq)((IterableLike)((SeqLike)this.getWorkers().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Machine x$7) {
                return new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])x$7.name().split("-")).last())).toInt();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).reverse()).take(num);
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Destroying workers.");
        }
        this.sparkdeployer$SparkDeployer$$machines().destroyMachines((Set<String>)((TraversableOnce)workers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Machine x$8) {
                return x$8.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public void destroyCluster() {
        this.sparkdeployer$SparkDeployer$$machines().destroyMachines((Set<String>)((TraversableOnce)((TraversableLike)this.getWorkers().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getMasterOpt()), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Machine x$9) {
                return x$9.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public void showMachines() {
        Option<Machine> option;
        block9: {
            block8: {
                BoxedUnit boxedUnit;
                block7: {
                    BoxedUnit boxedUnit2;
                    option = this.getMasterOpt();
                    None$ none$ = None$.MODULE$;
                    Option<Machine> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    if (this.log().underlying().isInfoEnabled()) {
                        this.log().underlying().info("No master found.");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                Machine master = (Machine)some.x();
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[master] ", ". IP address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{master.name(), master.address()})), new StringBuilder().append((Object)"Login command: ").append((Object)new SSH(master.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).getCommand()).toString(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Web UI: http://", ":8080"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{master.address()}))}))).mkString("\n"));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
            }
            ((IterableLike)this.getWorkers().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Machine x$10) {
                    return new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])x$10.name().split("-")).last())).toInt();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkDeployer $outer;

                public final void apply(Machine worker) {
                    if (this.$outer.log().underlying().isInfoEnabled()) {
                        this.$outer.log().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[worker] ", ". IP address: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{worker.name(), worker.address()})));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError(option);
    }

    public void uploadJar(File jar) {
        Option<Machine> option = this.getMasterOpt();
        None$ none$ = None$.MODULE$;
        Option<Machine> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw package$.MODULE$.error("No master found.");
        }
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            Machine master = (Machine)some.x();
            String masterAddress = master.address();
            String sshCmd = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssh"}))).$plus$plus((GenTraversableOnce)this.clusterConf().pem().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(String f) {
                    return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-i", f}));
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            }), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-o", "UserKnownHostsFile=/dev/null", "-o", "StrictHostKeyChecking=no"})), Seq$.MODULE$.canBuildFrom())).mkString(" ");
            Seq uploadJarCmd = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rsync", "--progress", "-ve", sshCmd, jar.getAbsolutePath(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "@", ":~/job.jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clusterConf().user(), masterAddress}))}));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(uploadJarCmd.mkString(" "));
            }
            if (scala.sys.process.package$.MODULE$.stringSeqToProcess(uploadJarCmd).$bang() != 0) {
                throw package$.MODULE$.error("[rsync-error] Failed uploading jar.");
            }
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder().append((Object)"Jar uploaded, you can now login to master and submit the job. Login command: ").append((Object)new SSH(master.address(), SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.clusterConf()).getCommand()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new MatchError(option);
    }

    public void submitJob(File jar, Seq<String> args, String mainClass) {
        this.withFailover((Function0)new Serializable(this, jar, args, mainClass){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkDeployer $outer;
            private final File jar$1;
            public final Seq args$1;
            public final String mainClass$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.uploadJar(this.jar$1);
                if (this.$outer.log().underlying().isWarnEnabled()) {
                    this.$outer.log().underlying().warn("You're submitting job directly, please make sure you have a stable network connection.");
                }
                this.$outer.getMasterOpt().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$submitJob$1 $outer;

                    public final int apply(Machine master) {
                        String masterAddress = master.address();
                        String string = "job.jar";
                        String submitJobCmd = ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"./", "/bin/spark-submit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().sparkDirName()})), "--master", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark://", ":7077"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{masterAddress}))}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.$outer.mainClass$1).orElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$submitJob$1$$anonfun$apply$mcV$sp$2 $outer;

                            public final Option<String> apply() {
                                return this.$outer.sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer().sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().mainClass();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        })).toSeq().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String c) {
                                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--class", c}));
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().appName()).toSeq().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String n) {
                                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--name", n}));
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().driverMemory()).toSeq().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String m) {
                                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--driver-memory", m}));
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().executorMemory()).toSeq().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String m) {
                                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--executor-memory", m}));
                            }
                        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf().enableS3A() ? Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--jars", "aws-java-sdk-1.7.4.jar,hadoop-aws-2.7.1.jar", "--conf", "spark.hadoop.fs.s3a.impl=org.apache.hadoop.fs.s3a.S3AFileSystem", "--conf", "spark.hadoop.fs.s3a.buffer.dir=/tmp"})) : Seq$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.$outer.args$1.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).mkString(" ");
                        return new SSH(masterAddress, SSH$.MODULE$.apply$default$2(), SSH$.MODULE$.apply$default$3(), SSH$.MODULE$.apply$default$4(), SSH$.MODULE$.apply$default$5(), SSH$.MODULE$.apply$default$6(), SSH$.MODULE$.apply$default$7(), this.$outer.sparkdeployer$SparkDeployer$$anonfun$$$outer().clusterConf()).withRemoteCommand(submitJobCmd).withAWSCredentials().withTTY().withErrorMessage("Job submission failed.").run();
                    }

                    public /* synthetic */ $anonfun$submitJob$1 sparkdeployer$SparkDeployer$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SparkDeployer sparkdeployer$SparkDeployer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.jar$1 = jar$1;
                this.args$1 = args$1;
                this.mainClass$1 = mainClass$1;
            }
        });
    }

    public String submitJob$default$3() {
        return null;
    }

    public SparkDeployer(Config config) {
        block4: {
            Machines machines;
            block3: {
                String string;
                block2: {
                    this.config = config;
                    Logging.class.$init$((Logging)this);
                    this.clusterConf = new ClusterConf(config);
                    this.ec = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)new ForkJoinPool(this.clusterConf().threadPoolSize()));
                    this.sparkdeployer$SparkDeployer$$masterName = new StringBuilder().append((Object)this.clusterConf().clusterName()).append((Object)"-master").toString();
                    this.sparkdeployer$SparkDeployer$$workerPrefix = new StringBuilder().append((Object)this.clusterConf().clusterName()).append((Object)"-worker").toString();
                    String string2 = string = this.clusterConf().platform();
                    if ("ec2" != null ? !"ec2".equals(string2) : string2 != null) break block2;
                    machines = new EC2Machines(config);
                    break block3;
                }
                String string3 = string;
                if ("openstack" != null ? !"openstack".equals(string3) : string3 != null) break block4;
                machines = new OSMachines(config);
            }
            this.sparkdeployer$SparkDeployer$$machines = machines;
            return;
        }
        throw package$.MODULE$.error("unsupported platform");
    }
}

