/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.redis.script.manager.core;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;

public abstract class ScriptManager<K, V> {
    protected String sha1;

    public abstract Object eval(K[] var1);

    public abstract Object eval(K[] var1, V[] var2);

    protected String getSHA1(V script) {
        if (this.sha1 == null) {
            this.sha1 = this.digestSHA1(script);
        }
        return this.sha1;
    }

    protected String digestSHA1(V script) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to instantiate SHA-1 message digest", e);
        }
        return DatatypeConverter.printHexBinary((byte[])messageDigest.digest(script.toString().getBytes(StandardCharsets.UTF_8)));
    }
}

