/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.exception.Route360ClientRuntimeException;

public final class IOUtil {
    private IOUtil() {
    }

    public static <T> T cloneObjects(T object, Class<T> clazz) {
        try {
            ObjectMapper om = new ObjectMapper();
            return (T)om.readValue(om.writeValueAsString(object), clazz);
        }
        catch (IOException e) {
            throw new Route360ClientRuntimeException("Could not duplicate travel options due to: " + e.getMessage());
        }
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    public static String getResultString(Response response) {
        return ((String)response.readEntity(String.class)).replace("callback(", "").replaceAll("\\)$", "");
    }
}

