/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.enums.TravelType;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.geo.Coordinate;
import net.motionintelligence.client.api.request.config.builder.JSONBuilder;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class RequestConfigurator {
    private static final Logger LOG = Logger.getLogger(RequestConfigurator.class);

    private RequestConfigurator() {
    }

    public static String getConfig(TravelOptions travelOptions) throws Route360ClientException {
        LOG.trace((Object)"Creating configuration...");
        String config = RequestConfigurator.getCommonConfig(travelOptions);
        LOG.trace((Object)"Configuration created.");
        return config;
    }

    private static String getCommonConfig(TravelOptions travelOptions) throws Route360ClientException {
        StringBuilder config = JSONBuilder.beginJson(new StringBuilder());
        try {
            if (travelOptions.getTravelTimes() != null && !travelOptions.getTravelTimes().isEmpty()) {
                JSONBuilder.append(config, "polygon", RequestConfigurator.getPolygonObject(travelOptions));
            }
            if (travelOptions.getIntersectionMode() != null) {
                JSONBuilder.appendString(config, "intersectionMode", (Object)travelOptions.getIntersectionMode());
            }
            if (travelOptions.getSources() != null && !travelOptions.getSources().isEmpty()) {
                JSONBuilder.append(config, "sources", RequestConfigurator.getSources(travelOptions));
            }
            if (travelOptions.getTargets() != null && !travelOptions.getTargets().isEmpty()) {
                JSONBuilder.append(config, "targets", RequestConfigurator.getTargets(travelOptions));
            }
            if (travelOptions.getPathSerializer() != null) {
                JSONBuilder.appendString(config, "pathSerializer", travelOptions.getPathSerializer().getPathSerializerName());
            }
            if (travelOptions.isElevationEnabled() != null) {
                JSONBuilder.append(config, "elevation", travelOptions.isElevationEnabled());
            }
            if (travelOptions.getReverse() != null) {
                JSONBuilder.append(config, "reverse", travelOptions.getReverse());
            }
            if (travelOptions.getEdgeWeightType() != null) {
                JSONBuilder.appendString(config, "edgeWeight", (Object)travelOptions.getEdgeWeightType());
            }
            if (travelOptions.getStatisticGroupId() != null) {
                JSONBuilder.appendString(config, "statisticGroupId", travelOptions.getStatisticGroupId());
            }
            if (travelOptions.getStatisticIds() != null) {
                JSONBuilder.append(config, "statistics", travelOptions.getStatisticIds());
            }
            if (travelOptions.getServiceUrl() != null) {
                JSONBuilder.append(config, "serviceUrl", "\"" + travelOptions.getServiceUrl() + "\"");
            }
            if (travelOptions.getServiceKey() != null) {
                JSONBuilder.append(config, "serviceKey", "\"" + travelOptions.getServiceKey() + "\"");
            }
            if (travelOptions.getFormat() != null) {
                JSONBuilder.append(config, "format", "\"" + travelOptions.getFormat().toString().toLowerCase() + "\"");
            }
            if (travelOptions.getBoundingBox() != null) {
                JSONBuilder.append(config, "boundingBox", "\"" + travelOptions.getBoundingBox() + "\"");
            }
            if (travelOptions.getOsmTypes() != null) {
                ObjectMapper mapper = new ObjectMapper();
                JSONBuilder.append(config, "osmTypes", mapper.writeValueAsString(travelOptions.getOsmTypes()));
            }
            JSONBuilder.append(config, "onlyPrintReachablePoints", travelOptions.getOnlyPrintReachablePoints());
            JSONBuilder.appendAndEnd(config, "maxEdgeWeight", travelOptions.getMaxEdgeWeight());
        }
        catch (Exception e) {
            throw new Route360ClientException("Could not generate r360 config object", e);
        }
        return config.toString();
    }

    private static JSONObject getPolygonObject(TravelOptions travelOptions) throws JSONException {
        JSONObject polygon = new JSONObject();
        polygon.put("values", (Object)new JSONArray(travelOptions.getTravelTimes()));
        polygon.put("intersectionMode", (Object)travelOptions.getIntersectionMode());
        polygon.put("pointReduction", travelOptions.isPointReduction());
        polygon.put("minPolygonHoleSize", travelOptions.getMinPolygonHoleSize());
        if (travelOptions.getSrid() != null) {
            polygon.put("srid", (Object)travelOptions.getSrid());
        }
        if (travelOptions.getBuffer() != null) {
            polygon.put("buffer", (Object)travelOptions.getBuffer());
        }
        if (travelOptions.getSimplify() != null) {
            polygon.put("simplify", (Object)travelOptions.getSimplify());
        }
        if (travelOptions.getPolygonSerializerType() != null) {
            polygon.put("serializer", (Object)travelOptions.getPolygonSerializerType().getPolygonSerializerName());
        }
        return polygon;
    }

    private static JSONArray getSources(TravelOptions travelOptions) throws JSONException {
        JSONArray sources = new JSONArray();
        for (Coordinate src : travelOptions.getSources().values()) {
            JSONObject source = RequestConfigurator.getSourceObject(travelOptions, src);
            sources.put((Object)source);
        }
        return sources;
    }

    private static StringBuilder getTargets(TravelOptions travelOptions) {
        StringBuilder targetsBuilder = new StringBuilder().append("[");
        for (Coordinate trg : travelOptions.getTargets().values()) {
            RequestConfigurator.buildTarget(targetsBuilder, trg).append(",");
        }
        targetsBuilder.deleteCharAt(targetsBuilder.length() - 1);
        targetsBuilder.append("]");
        return targetsBuilder;
    }

    private static StringBuilder buildTarget(StringBuilder targetsBuilder, Coordinate trg) {
        JSONBuilder.beginJson(targetsBuilder);
        JSONBuilder.appendString(targetsBuilder, "id", trg.getId());
        JSONBuilder.append(targetsBuilder, "lat", trg.getY());
        JSONBuilder.appendAndEnd(targetsBuilder, "lng", trg.getX());
        return targetsBuilder;
    }

    private static JSONObject getTravelMode(TravelOptions travelOptions, TravelType travelType) throws JSONException {
        JSONObject travelMode = new JSONObject();
        switch (travelType) {
            case TRANSIT: {
                travelMode.put("frame", (Object)new JSONObject().put("time", travelOptions.getTime()).put("date", travelOptions.getDate()).put("duration", travelOptions.getFrame()));
                if (travelOptions.getMaxTransfers() == null || travelOptions.getMaxTransfers() < 0) break;
                travelMode.put("maxTransfers", (Object)travelOptions.getMaxTransfers());
                break;
            }
            case WALK: {
                travelMode.put("speed", travelOptions.getWalkSpeed());
                travelMode.put("uphill", travelOptions.getWalkUphill());
                travelMode.put("downhill", travelOptions.getWalkDownhill());
                break;
            }
            case BIKE: {
                travelMode.put("speed", travelOptions.getBikeSpeed());
                travelMode.put("uphill", travelOptions.getBikeUphill());
                travelMode.put("downhill", travelOptions.getBikeDownhill());
                break;
            }
            case CAR: {
                travelMode.put("rushHour", travelOptions.getRushHour());
                break;
            }
        }
        travelMode.put("recommendations", travelOptions.getRecommendations());
        return travelMode;
    }

    private static TravelType getTravelType(TravelOptions travelOptions, Coordinate src) {
        TravelType travelType = travelOptions.getTravelType();
        if (src.getTravelType() != null && src.getTravelType() != travelType && src.getTravelType() != TravelType.UNSPECIFIED) {
            travelType = src.getTravelType();
        }
        return travelType;
    }

    private static JSONObject getSourceObject(TravelOptions travelOptions, Coordinate src) throws JSONException {
        TravelType travelType = RequestConfigurator.getTravelType(travelOptions, src);
        JSONObject travelMode = RequestConfigurator.getTravelMode(travelOptions, travelType);
        JSONObject source = new JSONObject().put("id", (Object)src.getId()).put("lat", src.getY()).put("lng", src.getX()).put("tm", (Object)new JSONObject().put(travelType.toString(), (Object)travelMode));
        if (travelOptions.getReverse() != null) {
            source.put("reverse", (Object)travelOptions.getReverse());
        }
        return source;
    }
}

