/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.request.config.RequestConfigurator;
import net.motionintelligence.client.api.response.RouteResponse;
import net.motionintelligence.client.api.util.IOUtil;
import net.motionintelligence.client.api.util.JsonUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class RouteRequest {
    private Client client;
    private TravelOptions travelOptions;
    private static final String CALLBACK = "callback";

    public RouteRequest(TravelOptions travelOptions) {
        this.client = ClientBuilder.newClient();
        this.travelOptions = travelOptions;
    }

    public RouteRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public RouteResponse get() throws Route360ClientException {
        long requestStart = System.currentTimeMillis();
        WebTarget request = this.client.target(this.travelOptions.getServiceUrl()).path("v1/route").queryParam("cb", new Object[]{CALLBACK}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()}).queryParam("cfg", new Object[]{IOUtil.encode(RequestConfigurator.getConfig(this.travelOptions))});
        Response response = request.request().get();
        return this.validateResponse(requestStart, response);
    }

    public String toCurl() throws Route360ClientException {
        String url = this.travelOptions.getServiceUrl().endsWith("/") ? this.travelOptions.getServiceUrl() : this.travelOptions.getServiceUrl() + "/";
        return "curl -X GET '" + url + "v1/route?cb=" + CALLBACK + "&key=" + this.travelOptions.getServiceKey() + "&cfg=" + IOUtil.encode(RequestConfigurator.getConfig(this.travelOptions)) + "'";
    }

    private RouteResponse validateResponse(long requestStart, Response response) throws Route360ClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject result = JsonUtil.parseString(IOUtil.getResultString(response));
            return new RouteResponse(this.travelOptions, JsonUtil.getJsonArray(JsonUtil.getJSONObject(result, "data"), "routes"), JsonUtil.getString(result, "code"), result.has("requestTime") ? (long)JsonUtil.getInt(result, "requestTime").intValue() : -1L);
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return new RouteResponse(this.travelOptions, new JSONArray(), "gateway-time-out", System.currentTimeMillis() - requestStart);
        }
        throw new Route360ClientException((String)response.readEntity(String.class), null);
    }
}

