/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.request;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.motionintelligence.client.api.TravelOptions;
import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.request.config.RequestConfigurator;
import net.motionintelligence.client.api.request.ssl.SslClientGenerator;
import net.motionintelligence.client.api.response.PolygonResponse;
import net.motionintelligence.client.api.util.IOUtil;
import net.motionintelligence.client.api.util.JsonUtil;
import org.json.JSONObject;

public class PolygonRequest {
    private Client client;
    private TravelOptions travelOptions;
    private String method;

    public PolygonRequest(Client client) {
        this.client = client;
    }

    public PolygonRequest() {
        this(SslClientGenerator.initClient());
    }

    public PolygonRequest(TravelOptions travelOptions) {
        this();
        this.travelOptions = travelOptions;
    }

    public PolygonRequest(TravelOptions travelOptions, String method) {
        this();
        this.travelOptions = travelOptions;
        this.method = method;
    }

    public PolygonRequest(Client client, TravelOptions travelOptions) {
        this.client = client;
        this.travelOptions = travelOptions;
    }

    public void setTravelOptions(TravelOptions options) {
        this.travelOptions = options;
    }

    public PolygonResponse get() throws Route360ClientException {
        Response response;
        long startTimeMillis = System.currentTimeMillis();
        WebTarget request = this.client.target(this.travelOptions.getServiceUrl()).path("v1/polygon" + ("POST".equals(this.method) ? "_post" : "")).queryParam("cb", new Object[]{"callback"}).queryParam("key", new Object[]{this.travelOptions.getServiceKey()});
        String config = RequestConfigurator.getConfig(this.travelOptions);
        if ("GET".equals(this.method)) {
            request = request.queryParam("cfg", new Object[]{IOUtil.encode(config)});
            response = request.request().get();
        } else if ("POST".equals(this.method)) {
            response = request.request().post(Entity.entity((Object)config, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        } else {
            throw new Route360ClientException("HTTP Method not supported: " + this.method, null);
        }
        long roundTripTimeMillis = System.currentTimeMillis() - startTimeMillis;
        return this.validateResponse(response, roundTripTimeMillis);
    }

    private PolygonResponse validateResponse(Response response, long roundTripTimeMillis) throws Route360ClientException {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String resultString = IOUtil.getResultString(response);
            long startParsing = System.currentTimeMillis();
            JSONObject result = JsonUtil.parseString(resultString);
            long parseTime = System.currentTimeMillis() - startParsing;
            String responseCode = JsonUtil.getString(result, "code");
            if ("no-route-found".equals(responseCode) || "could-not-connect-point-to-network".equals(responseCode) || "travel-time-exceeded".equals(responseCode) || "unknown-exception".equals(responseCode)) {
                throw new Route360ClientException(result.toString(), null);
            }
            return new PolygonResponse(this.travelOptions, result, JsonUtil.getString(result, "code"), JsonUtil.getLong(result, "requestTime"), roundTripTimeMillis, parseTime);
        }
        if (response.getStatus() == Response.Status.GATEWAY_TIMEOUT.getStatusCode()) {
            return new PolygonResponse(this.travelOptions, new JSONObject(), "gateway-time-out", roundTripTimeMillis, -1L);
        }
        throw new Route360ClientException("Status: " + response.getStatus() + ": " + (String)response.readEntity(String.class), null);
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

