/*
 * Decompiled with CFR 0.152.
 */
package net.motionintelligence.client.api.enums;

import net.motionintelligence.client.api.exception.Route360ClientException;
import net.motionintelligence.client.api.exception.Route360ClientRuntimeException;

public enum PolygonSerializerType {
    JSON_POLYGON_SERIALIZER,
    GEO_JSON_POLYGON_SERIALIZER;


    public static PolygonSerializerType getPolygonSerializer(String key) throws Route360ClientException {
        switch (key) {
            case "json": {
                return JSON_POLYGON_SERIALIZER;
            }
            case "geojson": {
                return GEO_JSON_POLYGON_SERIALIZER;
            }
        }
        throw new Route360ClientException(String.format("No polygon serializer available for key '%s'.", key));
    }

    public String getPolygonSerializerName() throws Route360ClientRuntimeException {
        switch (this) {
            case JSON_POLYGON_SERIALIZER: {
                return "json";
            }
            case GEO_JSON_POLYGON_SERIALIZER: {
                return "geojson";
            }
        }
        throw new Route360ClientRuntimeException(String.format("No polygon serializer name available for key '%s'.", new Object[]{this}));
    }
}

