/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.commons.datastructures;

import java.util.NoSuchElementException;

public final class Optional<Payload> {
    private final boolean hasValue;
    private final Payload value;

    public Optional() {
        this.value = null;
        this.hasValue = false;
    }

    public Optional(Payload value) {
        this.value = value;
        this.hasValue = true;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public Payload getValue() throws NoSuchElementException {
        if (!this.hasValue) {
            throw new NoSuchElementException("This optional has no value");
        }
        return this.value;
    }

    public int hashCode() {
        return 31 * (this.hasValue ? 1231 : 1237) + (null == this.value ? 0 : this.value.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Optional other = (Optional)object;
        if (this.hasValue != other.hasValue) {
            return false;
        }
        return (this.value != null || other.value == null) && this.value.equals(other.value);
    }

    public String toString() {
        return "Optional [hasValue=" + this.hasValue + ", value=" + this.value + "]";
    }
}

