package net.jangaroo.net {
import net.jangaroo.net.URI;

/**
 * A class implementing resolving and relativizing URIs
 * generic URI syntax as specified in <a href="http://www.rfc-editor.org/rfc/rfc3986.txt">RFC 3986</a>.
 *
 */
public class URIUtils {

  /**
   * Create an URI from its components
   */
  public native function create(scheme:String = null, authority:String = null, path:String = "", query:String = null, fragment:String = null):URI;

  /**
   * Parses the string into a {@link URI} instance.
   * @throws URIError if the syntax does not conform to <a href="http://www.rfc-editor.org/rfc/rfc3986.txt">RFC 3986</a>
   */
  public static native function parse(source:String):URI;

  /**
   * Relativize a reference uri against a base URI according to RFC 3986.
   * If both scheme and authority are equal, this method always returns a URI with a relative path,
   * even it an absolute path would be shorter.
   *
   * @param base the base URI. Must be an absolute URI.
   * @param reference the URI to relativize. Must be an absolute URI.
   * @return an URI which yields the reference URI when resolved against the given base URI
   * @throws URIError if base or reference is a relative URI
   */
  public static native function relativize(base:String, reference:String):String;

  /**
   * Resolve a uri against a base URI according to RFC 3986.
   * @param base the base uri
   * @param reference the uri to resolve
   * @return an absolute URI
   * @throws URIError if base is not an absolute URI
   */
  public static native function resolve(base:String, reference:String):String;

}
}