/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mongo.association;

import java.util.List;
import java.util.Map;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.mongo.Criteria;
import net.csdn.mongo.Document;
import net.csdn.mongo.association.Association;
import net.csdn.mongo.association.HasManyAssociation;
import net.csdn.mongo.association.Options;

public class HasOneAssociation
implements Association {
    private String foreignKey;
    private Document document;
    private Document childDocument;
    private Class kclass;
    private String name;

    public HasOneAssociation(String name, Options options) {
        this.kclass = options.kClass();
        this.foreignKey = options.foreignKey();
    }

    private HasOneAssociation(Class kclass, String foreignKey, Document document) {
        this.kclass = kclass;
        this.foreignKey = foreignKey;
        this.document = document;
    }

    @Override
    public Association build(Map params) {
        this.childDocument = (Document)ReflectHelper.staticMethod((Class)this.kclass, (String)"create", (Object[])new Object[]{params});
        return this;
    }

    @Override
    public Association remove(Document document) {
        this.childDocument = null;
        document.remove();
        return this;
    }

    @Override
    public Association doNotUseMePlease_newMe(Document document) {
        HasOneAssociation association = new HasOneAssociation(this.kclass, this.foreignKey, document);
        document.associations().put(this.name, association);
        return association;
    }

    @Override
    public void save() {
        this.document.save();
        this.document.reload();
        this.childDocument.attributes().put(this.foreignKey, this.document.attributes().get("_id"));
        this.childDocument.save();
        Map<String, Association> associationMap = this.childDocument.associations();
        for (Map.Entry<String, Association> entry : associationMap.entrySet()) {
            if (!(entry.getValue() instanceof HasManyAssociation) && !(entry.getValue() instanceof HasOneAssociation)) continue;
            entry.getValue().save();
        }
    }

    @Override
    public Criteria where(Map conditions) {
        return this.filter().where(conditions);
    }

    @Override
    public Criteria select(List fieldNames) {
        return this.filter().select(fieldNames);
    }

    @Override
    public Criteria order(Map orderBy) {
        return this.filter().order(orderBy);
    }

    @Override
    public Criteria skip(int skip) {
        return this.filter().skip(skip);
    }

    @Override
    public Criteria limit(int limit) {
        return this.filter().limit(limit);
    }

    @Override
    public int count() {
        return this.filter().count();
    }

    @Override
    public Criteria in(Map in) {
        return this.filter().in(in);
    }

    @Override
    public Criteria not(Map not) {
        return this.filter().not(not);
    }

    @Override
    public Criteria notIn(Map notIn) {
        return this.filter().notIn(notIn);
    }

    @Override
    public <T> T findById(Object id) {
        return this.filter().findById(id);
    }

    @Override
    public <T> T findOne() {
        List<T> items = this.findAll();
        if (WowCollections.isEmpty(items)) {
            return null;
        }
        return items.get(0);
    }

    @Override
    public <T> List<T> find(List list) {
        return this.filter().find(list);
    }

    @Override
    public <T> List<T> findAll() {
        return this.filter().findAll();
    }

    private Criteria filter() {
        return new Criteria(this.kclass).where(WowCollections.map((Object[])new Object[]{"_id", this.document.attributes().get(this.foreignKey)}));
    }
}

