/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.exception.AutoGeneration;
import net.csdn.common.logging.CSLogger;
import net.csdn.common.logging.Loggers;
import net.csdn.common.logging.support.MessageFormat;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.common.reflect.WowMethod;
import net.csdn.mongo.Callbacks;
import net.csdn.mongo.Criteria;
import net.csdn.mongo.MongoMongo;
import net.csdn.mongo.annotations.AfterCreate;
import net.csdn.mongo.annotations.AfterDestory;
import net.csdn.mongo.annotations.AfterSave;
import net.csdn.mongo.annotations.AfterUpdate;
import net.csdn.mongo.annotations.AfterValidation;
import net.csdn.mongo.annotations.BeforeCreate;
import net.csdn.mongo.annotations.BeforeDestroy;
import net.csdn.mongo.annotations.BeforeSave;
import net.csdn.mongo.annotations.BeforeUpdate;
import net.csdn.mongo.annotations.BeforeValidation;
import net.csdn.mongo.annotations.Transient;
import net.csdn.mongo.association.Association;
import net.csdn.mongo.association.BelongsToAssociation;
import net.csdn.mongo.association.HasManyAssociation;
import net.csdn.mongo.association.HasOneAssociation;
import net.csdn.mongo.association.Options;
import net.csdn.mongo.commands.Delete;
import net.csdn.mongo.commands.Insert;
import net.csdn.mongo.commands.Save;
import net.csdn.mongo.commands.Update;
import net.csdn.mongo.embedded.AssociationEmbedded;
import net.csdn.mongo.embedded.BelongsToAssociationEmbedded;
import net.csdn.mongo.embedded.HasManyAssociationEmbedded;
import net.csdn.mongo.embedded.HasOneAssociationEmbedded;
import net.csdn.mongo.validate.ValidateParse;
import net.csdn.mongo.validate.ValidateResult;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

public class Document {
    private static CSLogger logger = Loggers.getLogger(Document.class);
    @Transient
    protected Map attributes = WowCollections.map((Object[])new Object[0]);
    @Transient
    protected boolean new_record = true;
    @Transient
    protected Map<String, Association> associations = WowCollections.map((Object[])new Object[0]);
    @Transient
    protected Map<String, AssociationEmbedded> associationsEmbedded = WowCollections.map((Object[])new Object[0]);
    @Transient
    public Document _parent;
    @Transient
    public String associationEmbeddedName;
    protected static Map parent$_primaryKey;
    protected static boolean parent$_embedded;
    protected static List<String> parent$_fields;
    protected static DBCollection parent$_collection;
    protected static String parent$_collectionName;
    protected static Map<String, Association> parent$_associations;
    protected static Map<String, AssociationEmbedded> parent$_associations_embedded;
    protected static Map<String, String> parent$_alias_names;
    public static MongoMongo mongoMongo;
    protected static Map parent$_validate_info;
    public final List<ValidateResult> validateResults = WowCollections.list((Object[])new ValidateResult[0]);
    public static final List validateParses;
    protected Map<Callbacks.Callback, List<WowMethod>> callbacks = WowCollections.map((Object[])new Object[0]);

    public <T> T attr(String key, Class<T> clzz) {
        return (T)this.attributes.get((String)ReflectHelper.staticMethod(this.getClass(), (String)"translateFromAlias", (Object[])new Object[]{key}));
    }

    public Document attr(String key, Object obj) {
        this.attributes.put((String)ReflectHelper.staticMethod(this.getClass(), (String)"translateFromAlias", (Object[])new Object[]{key}), obj);
        return this;
    }

    public static String translateFromAlias(String key) {
        if (parent$_alias_names != null && parent$_alias_names.containsKey(key)) {
            return parent$_alias_names.get(key);
        }
        return key;
    }

    public static Map translateKeyForParams(Map params) {
        Map newParams = WowCollections.map((Object[])new Object[0]);
        for (Object key : params.keySet()) {
            String keyStr = (String)key;
            newParams.put(Document.translateFromAlias(keyStr), params.get(key));
        }
        params.clear();
        params.putAll(newParams);
        return params;
    }

    public static String translateToAlias(String key) {
        if (parent$_alias_names != null) {
            for (Map.Entry<String, String> entry : parent$_alias_names.entrySet()) {
                if (!key.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return key;
    }

    public static String collectionName() {
        return parent$_collectionName;
    }

    public static boolean embedded() {
        return parent$_embedded;
    }

    public static boolean embedded(boolean isEmbedded) {
        parent$_embedded = isEmbedded;
        return parent$_embedded;
    }

    public static DBCollection collection() {
        return parent$_collection;
    }

    public static Map<String, Association> associationsMetaData() {
        return parent$_associations;
    }

    public static Map<String, AssociationEmbedded> associationsEmbeddedMetaData() {
        return parent$_associations_embedded;
    }

    public static List fields() {
        return parent$_fields;
    }

    public boolean merge(Map item) {
        this.attributes.putAll(item);
        this.copyAllAttributesToPojoFields();
        return true;
    }

    protected static DBCollection storeIn(String name) {
        parent$_collectionName = name;
        parent$_collection = mongoMongo.database().getCollection(name);
        return parent$_collection;
    }

    protected static void validate(String fieldName, Map validate) {
        if (parent$_validate_info == null) {
            parent$_validate_info = WowCollections.map((Object[])new Object[0]);
        }
        parent$_validate_info = WowCollections.map((Object[])new Object[]{fieldName, validate});
    }

    protected static Map validate_info() {
        return parent$_validate_info;
    }

    protected static void index(Map keys, Map indexOptions) {
        parent$_collection.ensureIndex(Document.translateMapToDBObject(keys), Document.translateMapToDBObject(indexOptions));
    }

    public static DBObject translateMapToDBObject(Map map) {
        BasicDBObject query = new BasicDBObject();
        query.putAll(map);
        return query;
    }

    protected static void alias(String originalName, String aliasName) {
        if (parent$_alias_names == null) {
            parent$_alias_names = WowCollections.map((Object[])new Object[]{aliasName, originalName});
        } else {
            parent$_alias_names.put(aliasName, originalName);
        }
    }

    public static <T extends Document> T create(Map map) {
        throw new AutoGeneration();
    }

    public static <T extends Document> T create9(Map map) {
        throw new AutoGeneration();
    }

    public boolean save() {
        if (this.valid()) {
            return Save.execute(this);
        }
        return false;
    }

    public boolean save(boolean validate) {
        if (validate && this.valid()) {
            return Save.execute(this);
        }
        return false;
    }

    public boolean insert() {
        if (this.valid()) {
            return Insert.execute(this, false);
        }
        return false;
    }

    public boolean insert(boolean validate) {
        if (validate && this.valid()) {
            return Insert.execute(this, false);
        }
        return false;
    }

    public boolean update() {
        if (this.valid()) {
            return Update.execute(this, false);
        }
        return false;
    }

    public boolean update(boolean validate) {
        if (validate && this.valid()) {
            return Update.execute(this, false);
        }
        return false;
    }

    public boolean valid() {
        this.runCallbacks(Callbacks.Callback.before_validation, new Object[0]);
        if (this.validateResults.size() > 0) {
            return false;
        }
        for (Object validateParse : validateParses) {
            ((ValidateParse)validateParse).parse(this, this.validateResults);
        }
        this.runCallbacks(Callbacks.Callback.after_validation, new Object[0]);
        return this.validateResults.size() == 0;
    }

    public void remove() {
        Delete.execute(this);
    }

    public void remove(Document child) {
        String name = child.associationEmbeddedName;
        AssociationEmbedded association = this.associationEmbedded().get(name);
        if (association instanceof HasManyAssociationEmbedded) {
            List children = (List)this.attributes().get(name);
            Map shouldRemove = null;
            for (Map wow : children) {
                if (!child.id().equals(wow.get("_id"))) continue;
                shouldRemove = wow;
                break;
            }
            if (shouldRemove != null) {
                children.remove(shouldRemove);
            }
        } else {
            this.attributes().remove(name);
        }
        this.associationEmbedded().get(name).remove(child);
        this.save();
    }

    public void copyPojoFieldsToAllAttributes() {
        try {
            List<PropertyDescriptor> fromPd = Arrays.asList(Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors());
            for (PropertyDescriptor pd : fromPd) {
                if (pd.getName().equals("class")) continue;
                this.attributes.put((String)ReflectHelper.staticMethod(this.getClass(), (String)"translateFromAlias", (Object[])new Object[]{pd.getName()}), pd.getReadMethod().invoke((Object)this, new Object[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyAllAttributesToPojoFields() {
        BasicDBObject newAttributes = new BasicDBObject();
        newAttributes.putAll(this.attributes());
        Map tempMap = (Map)ReflectHelper.staticField(this.getClass(), (String)"parent$_alias_names");
        try {
            if (tempMap != null && tempMap.size() > 0) {
                for (Map.Entry entry : tempMap.entrySet()) {
                    Object temp = this.attributes().get(entry.getValue());
                    if (temp == null) continue;
                    newAttributes.put((String)entry.getKey(), temp);
                }
            }
            BeanUtils.copyProperties((Object)this, (Object)newAttributes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object id() {
        return this.attributes.get("_id");
    }

    public Object id(Object id) {
        this.attributes.put("_id", id);
        return id;
    }

    public Document fields(String ... names) {
        for (String name : names) {
            Document.fields().add(name);
        }
        return this;
    }

    public Map<String, Association> associations() {
        return this.associations;
    }

    public Map<String, AssociationEmbedded> associationEmbedded() {
        return this.associationsEmbedded;
    }

    public Map reload() {
        this.attributes.putAll(Document.collection().findOne((Object)WowCollections.map((Object[])new Object[]{"_id", this.attributes.get("_id")})).toMap());
        return this.attributes;
    }

    public Map attributes() {
        return this.attributes;
    }

    public static HasManyAssociationEmbedded hasManyEmbedded(String name, Options options) {
        HasManyAssociationEmbedded association = new HasManyAssociationEmbedded(name, options);
        if (parent$_associations_embedded == null) {
            parent$_associations_embedded = WowCollections.map((Object[])new Object[0]);
        }
        parent$_associations_embedded.put(name, association);
        return association;
    }

    public static BelongsToAssociationEmbedded belongsToEmbedded(String name, Options options) {
        BelongsToAssociationEmbedded association = new BelongsToAssociationEmbedded(name, options);
        if (parent$_associations_embedded == null) {
            parent$_associations_embedded = WowCollections.map((Object[])new Object[0]);
        }
        parent$_associations_embedded.put(name, association);
        return association;
    }

    public static HasOneAssociationEmbedded hasOneEmbedded(String name, Options options) {
        HasOneAssociationEmbedded association = new HasOneAssociationEmbedded(name, options);
        if (parent$_associations_embedded == null) {
            parent$_associations_embedded = WowCollections.map((Object[])new Object[0]);
        }
        parent$_associations_embedded.put(name, association);
        return association;
    }

    public static HasManyAssociation hasMany(String name, Options options) {
        HasManyAssociation association = new HasManyAssociation(name, options);
        if (parent$_associations == null) {
            parent$_associations = WowCollections.map((Object[])new Object[0]);
        }
        parent$_associations.put(name, association);
        return association;
    }

    public static HasOneAssociation hasOne(String name, Options options) {
        HasOneAssociation association = new HasOneAssociation(name, options);
        if (parent$_associations == null) {
            parent$_associations = WowCollections.map((Object[])new Object[0]);
        }
        parent$_associations.put(name, association);
        return association;
    }

    public static BelongsToAssociation belongsTo(String name, Options options) {
        BelongsToAssociation association = new BelongsToAssociation(name, options);
        if (parent$_associations == null) {
            parent$_associations = WowCollections.map((Object[])new Object[0]);
        }
        parent$_associations.put(name, association);
        return association;
    }

    public String toString() {
        String attrs = WowCollections.join((Collection)WowCollections.iterate_map((Map)this.attributes, (WowCollections.MapIterator)new WowCollections.MapIterator<String, Object>(){

            public Object iterate(String key, Object value) {
                if (value instanceof String) {
                    value = StringUtils.substring((String)((String)value), (int)0, (int)50);
                }
                return MessageFormat.format((String)"{}: {}", (Object[])new Object[]{key, value});
            }
        }), (String)",");
        return "#<" + this.getClass().getSimpleName() + " _id: " + this.id() + ", " + attrs + ">";
    }

    public Document _root() {
        Document doc = this;
        while (doc._parent != null) {
            doc = doc._parent;
        }
        return doc == null ? this : doc;
    }

    public boolean newRecord(boolean saved) {
        this.new_record = saved;
        return this.new_record;
    }

    public static Criteria where(Map conditions) {
        throw new AutoGeneration();
    }

    public static Criteria select(List fieldNames) {
        throw new AutoGeneration();
    }

    public static Criteria order(Map orderBy) {
        throw new AutoGeneration();
    }

    public static Criteria skip(int skip) {
        throw new AutoGeneration();
    }

    public static Criteria limit(int limit) {
        throw new AutoGeneration();
    }

    public static int count() {
        throw new AutoGeneration();
    }

    public static Criteria in(Map in) {
        throw new AutoGeneration();
    }

    public static Criteria not(Map not) {
        throw new AutoGeneration();
    }

    public static Criteria notIn(Map notIn) {
        throw new AutoGeneration();
    }

    public static <T> T findById(Object id) {
        throw new AutoGeneration();
    }

    public static <T> List<T> find(List list) {
        throw new AutoGeneration();
    }

    public static <T> List<T> findAll() {
        throw new AutoGeneration();
    }

    protected void collectCallback() {
        Method[] methods = this.getClass().getDeclaredMethods();
        if (this.callbacks.size() > 0) {
            return;
        }
        for (Method method : methods) {
            WowMethod wowMethod = new WowMethod((Object)this, method);
            if (method.isAnnotationPresent(BeforeSave.class)) {
                this.putAndAdd(Callbacks.Callback.before_save, wowMethod);
            }
            if (method.isAnnotationPresent(BeforeCreate.class)) {
                this.putAndAdd(Callbacks.Callback.before_create, wowMethod);
            }
            if (method.isAnnotationPresent(BeforeDestroy.class)) {
                this.putAndAdd(Callbacks.Callback.before_destroy, wowMethod);
            }
            if (method.isAnnotationPresent(BeforeUpdate.class)) {
                this.putAndAdd(Callbacks.Callback.before_update, wowMethod);
            }
            if (method.isAnnotationPresent(BeforeValidation.class)) {
                this.putAndAdd(Callbacks.Callback.before_validation, wowMethod);
            }
            if (method.isAnnotationPresent(AfterCreate.class)) {
                this.putAndAdd(Callbacks.Callback.after_create, wowMethod);
            }
            if (method.isAnnotationPresent(AfterDestory.class)) {
                this.putAndAdd(Callbacks.Callback.after_destroy, wowMethod);
            }
            if (method.isAnnotationPresent(AfterSave.class)) {
                this.putAndAdd(Callbacks.Callback.after_save, wowMethod);
            }
            if (method.isAnnotationPresent(AfterUpdate.class)) {
                this.putAndAdd(Callbacks.Callback.after_update, wowMethod);
            }
            if (!method.isAnnotationPresent(AfterValidation.class)) continue;
            this.putAndAdd(Callbacks.Callback.after_validation, wowMethod);
        }
    }

    public void runCallbacks(Callbacks.Callback callback, Object ... params) {
        List<WowMethod> wowMethods;
        if (this.callbacks.size() == 0) {
            this.collectCallback();
        }
        if ((wowMethods = this.callbacks.get((Object)callback)) == null) {
            return;
        }
        for (WowMethod wowMethod : wowMethods) {
            wowMethod.invoke(params);
        }
    }

    private void putAndAdd(Callbacks.Callback key, WowMethod item) {
        if (this.callbacks.containsKey((Object)key)) {
            this.callbacks.get((Object)key).add(item);
        } else {
            this.callbacks.put(key, WowCollections.list((Object[])new WowMethod[]{item}));
        }
    }

    public static Criteria nativeQuery(String tableName) {
        return new Criteria(tableName);
    }

    static {
        validateParses = WowCollections.list((Object[])new Object[0]);
    }
}

