/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.csdn.common.collections.WowCollections;
import net.csdn.common.reflect.ReflectHelper;
import net.csdn.mongo.Document;

public class Criteria {
    private Class<Document> kclass;
    private String tableName;
    private Map options = WowCollections.map((Object[])new Object[0]);
    private Map selector = WowCollections.map((Object[])new Object[0]);
    private static final String AGGREGATE_REDUCE = "function(obj, prev) { prev.count++; }";
    private static Map<String, Integer> SortMap = WowCollections.map((Object[])new Object[]{"asc", 1, "desc", -1});
    private DBCollection collection;

    public Criteria aggregate() {
        return this;
    }

    public Criteria not(Map attributes) {
        this.updateSelector(attributes, "$ne");
        return this;
    }

    public Criteria where(Map _selector) {
        this.selector.putAll(_selector);
        return this;
    }

    public Criteria where(String _selector) {
        this.selector.put("$where", _selector);
        return this;
    }

    public Criteria all(Map _selector) {
        this.updateSelector(_selector, "$all");
        return this;
    }

    public <T> List<T> find(List list) {
        return this.in(WowCollections.map((Object[])new Object[]{"_id", list})).fetch();
    }

    public <T> List<T> findAll() {
        return this.all(WowCollections.map((Object[])new Object[0])).fetch();
    }

    public <T> T findById(Object id) {
        return this.where(WowCollections.map((Object[])new Object[]{"_id", id})).singleFetch();
    }

    public Criteria and(Map _selector) {
        return this.where(_selector);
    }

    public int count() {
        return this.collection().find(this.translateMapToDBObject(this.selector)).count();
    }

    public int length() {
        return this.count();
    }

    public void update(Map obj) {
        this.collection().update(this.translateMapToDBObject(this.selector), this.translateMapToDBObject(WowCollections.map((Object[])new Object[]{"$set", obj})));
    }

    public void updateMulti(Map obj) {
        this.innerUpdate("$set", obj);
    }

    public void addToSet(Map obj) {
        this.innerUpdate("$addToSet", obj);
    }

    public void inc(Map obj) {
        this.innerUpdate("$inc", obj);
    }

    public void pop(Map obj) {
        this.innerUpdate("$pop", obj);
    }

    public void pull(Map obj) {
        this.innerUpdate("$pull", obj);
    }

    public void pullAll(Map obj) {
        this.innerUpdate("$pullAll", obj);
    }

    public void push(Map obj) {
        this.innerUpdate("$push", obj);
    }

    public void pushAll(Map obj) {
        this.innerUpdate("$pushAll", obj);
    }

    public void rename(Map obj) {
        this.innerUpdate("$rename", obj);
    }

    public void set(Map obj) {
        this.innerUpdate("$set", obj);
    }

    public void unset(Map obj) {
        this.innerUpdate("$unset", obj);
    }

    public void remove() {
        this.collection().findAndRemove(this.translateMapToDBObject(this.selector));
    }

    private void innerUpdate(String operateType, Map obj) {
        this.collection().updateMulti(this.translateMapToDBObject(this.selector), this.translateMapToDBObject(WowCollections.map((Object[])new Object[]{operateType, obj})));
    }

    public Criteria in(Map _selector) {
        this.updateSelector(_selector, "$in");
        return this;
    }

    public Criteria id(Object id) {
        this.selector.put("_id", id);
        return this;
    }

    public Criteria notIn(Map _selector) {
        this.updateSelector(_selector, "$nin");
        return this;
    }

    public <T> T singleFetch() {
        this.options.put("limit", 1);
        List objects = this.fetch();
        if (WowCollections.isEmpty((Collection)objects)) {
            return null;
        }
        return (T)objects.get(0);
    }

    public boolean exists() {
        return this.count() > 0;
    }

    private void processSelector() {
        if (this.kclass != null) {
            this.selector = (Map)ReflectHelper.staticMethod(this.kclass, (String)"translateKeyForParams", (Object[])new Object[]{this.selector});
        }
    }

    private void init() {
        if (this.kclass != null) {
            this.collection = (DBCollection)ReflectHelper.staticMethod(this.kclass, (String)"collection", (Object[])new Object[0]);
        }
        if (this.collection == null && !WowCollections.isEmpty((String)this.tableName)) {
            this.collection = Document.mongoMongo.collection(this.tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List fetch() {
        DBCursor dbCursor;
        this.processOptions();
        this.processSelector();
        List result = WowCollections.list((Object[])new Object[0]);
        Map sort = (Map)this.options.get("sort");
        Integer skip = (Integer)this.options.get("skip");
        Integer limit = (Integer)this.options.get("limit");
        Map fields = (Map)this.options.get("fields");
        DBCursor dBCursor = dbCursor = fields == null ? this.collection().find(this.translateMapToDBObject(this.selector)) : this.collection().find(this.translateMapToDBObject(this.selector), this.translateMapToDBObject(fields));
        if (sort != null) {
            dbCursor.sort(this.translateMapToDBObject(sort));
        }
        if (skip != null) {
            dbCursor.skip(skip.intValue());
        }
        if (limit != null) {
            dbCursor.limit(limit.intValue());
        }
        try {
            while (dbCursor.hasNext()) {
                DBObject dbObject = dbCursor.next();
                if (this.kclass == null) {
                    result.add(dbObject.toMap());
                    continue;
                }
                result.add(ReflectHelper.staticMethod(this.kclass, (String)"create", (Object[])new Object[]{dbObject.toMap()}));
            }
        }
        finally {
            dbCursor.close();
        }
        return result;
    }

    public Criteria select(List fieldNames) {
        this.options.put("fields", fieldNames);
        return this;
    }

    public Criteria order(Map orderBy) {
        this.options.put("sort", orderBy);
        return this;
    }

    public Criteria skip(int skip) {
        this.options.put("skip", skip);
        return this;
    }

    public Criteria limit(int limit) {
        this.options.put("limit", limit);
        return this;
    }

    public <T> T first() {
        return this.singleFetch();
    }

    public <T> T one() {
        return this.first();
    }

    public <T> T last() {
        Map sorting = (Map)this.options.get("sort");
        if (sorting == null) {
            sorting = WowCollections.map((Object[])new Object[]{"_id", SortMap.get("desc")});
        }
        this.options.put("sort", sorting);
        this.options.put("limit", 1);
        List result = this.fetch();
        if (result == null) {
            return null;
        }
        return (T)result.get(0);
    }

    private Criteria updateSelector(Map attributes, String operator) {
        for (Object key : attributes.keySet()) {
            Object value = attributes.get(key);
            this.selector.put(key, WowCollections.map((Object[])new Object[]{operator, value}));
        }
        return this;
    }

    private DBObject translateMapToDBObject(Map map) {
        return Document.translateMapToDBObject(map);
    }

    public DBCollection collection() {
        return this.collection;
    }

    public Criteria(Class<Document> kclass) {
        this.kclass = kclass;
        this.init();
    }

    public Criteria(String tableName) {
        this.tableName = tableName;
        this.init();
    }

    private DBObject grouped(String start, String field, String reduce) {
        return this.collection().group(null, this.translateMapToDBObject(this.selector), (DBObject)new BasicDBObject("start", (Object)"start"), reduce.replaceAll("[field]", field));
    }

    private Map processOptions() {
        Map sorting;
        List fields = (List)this.options.remove("fields");
        if (fields != null) {
            HashMap<String, Integer> fieldsMap = new HashMap<String, Integer>();
            for (String str : fields) {
                fieldsMap.put(str, 1);
            }
            this.options.put("fields", fieldsMap);
        }
        if ((sorting = (Map)this.options.get("sort")) != null) {
            Map newSorting = WowCollections.map((Object[])new Object[0]);
            for (Map.Entry wow : sorting.entrySet()) {
                Object value = wow.getValue();
                if (value.equals("asc") || value.equals("desc")) {
                    newSorting.put(wow.getKey(), SortMap.get(value));
                    continue;
                }
                newSorting.put(wow.getKey(), value);
            }
            this.options.put("sort", newSorting);
        }
        return this.options;
    }

    private void filterOptions() {
        Integer page_num = (Integer)this.options.remove("page");
        Integer per_page_num = (Integer)this.options.remove("per_page");
        if (page_num != null || per_page_num != null) {
            if (per_page_num == null) {
                per_page_num = 20;
            }
            if (page_num == null) {
                page_num = 1;
            }
            this.options.put("limit", per_page_num);
            this.options.put("skip", page_num * per_page_num - per_page_num);
        }
    }
}

