/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;

class SourceMapRoute
implements Route {
    private final Resources resources;
    private final CompilerFacade compilerFacade;

    SourceMapRoute(Resources resources, CompilerFacade compilerFacade) {
        this.resources = resources;
        this.compilerFacade = compilerFacade;
    }

    @Override
    public boolean matchUri(String uri) {
        return (uri.endsWith(".coffee.map") || uri.endsWith(".litcoffee.map")) && this.resources.isPublic(SourceMapRoute.pathSource(uri));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) throws IOException {
        String uri = context.uri();
        Path mapPath = Paths.get(uri, new String[0]);
        Path sourcePath = SourceMapRoute.pathSource(uri);
        String compile = this.compilerFacade.compile(new SourceFile(mapPath, this.resources.read(sourcePath, StandardCharsets.UTF_8))).content();
        return new Payload("text/plain;charset=UTF-8", compile);
    }

    private static Path pathSource(String uri) {
        return Paths.get(Strings.substringBeforeLast(uri, ".map"), new String[0]);
    }
}

