/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.payload;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.CompilerException;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.ErrorPayload;
import net.codestory.http.errors.HttpException;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.logs.Logs;
import net.codestory.http.misc.Dates;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.Md5;
import net.codestory.http.payload.DataSupplier;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.StreamingOutput;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.ModelAndView;
import net.codestory.http.templating.Site;
import net.codestory.http.types.ContentTypes;

public class PayloadWriter {
    protected final Request request;
    protected final Response response;
    protected final Env env;
    protected final Site site;
    protected final Resources resources;
    protected final CompilerFacade compilers;

    public PayloadWriter(Request request, Response response, Env env, Site site, Resources resources, CompilerFacade compilers) {
        this.request = request;
        this.response = response;
        this.env = env;
        this.site = site;
        this.resources = resources;
        this.compilers = compilers;
    }

    public void writeAndClose(Payload payload) throws IOException {
        if (this.isAsync(payload)) {
            this.writeAndCloseAsync(payload);
        } else {
            this.writeAndCloseSync(payload);
        }
    }

    protected void writeAndCloseSync(Payload payload) throws IOException {
        if (payload.isError() && payload.rawContent() == null) {
            payload = this.errorPage(payload.code(), null).withHeaders(payload.headers()).withCookies(payload.cookies());
        }
        this.write(payload);
        this.close();
    }

    protected CompletableFuture<Void> writeAndCloseAsync(Payload payload) {
        CompletableFuture future = (CompletableFuture)payload.rawContent();
        return ((CompletableFuture)future.thenAccept(content -> {
            try {
                this.writeAndCloseSync(new Payload(content));
            }
            catch (Exception e) {
                this.writeErrorPage(e);
            }
        })).exceptionally(e -> {
            this.writeErrorPage((Throwable)e);
            return null;
        });
    }

    protected boolean isAsync(Payload payload) {
        return payload.rawContent() instanceof CompletableFuture;
    }

    public void writeErrorPage(Throwable e) {
        try {
            if (e instanceof CompilerException) {
                Logs.compilerError(e);
            } else if (!(e instanceof HttpException) && !(e instanceof NoSuchElementException)) {
                Logs.unexpectedError(e);
            }
            Payload errorPage = this.errorPage(e).withHeader("reason", e.getMessage());
            this.writeAndCloseSync(errorPage);
        }
        catch (IOException error) {
            Logs.unableToServeErrorPage(error);
        }
    }

    protected void close() {
        try {
            this.response.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void write(Payload payload) throws IOException {
        this.response.setHeaders(payload.headers());
        this.response.setCookies(payload.cookies());
        long lastModified = this.getLastModified(payload);
        if (lastModified > 0L) {
            String previousLastModified = Strings.stripQuotes(this.request.header("If-Modified-Since"));
            if (previousLastModified != null && lastModified < Dates.parseRfc1123(previousLastModified)) {
                this.response.setStatus(304);
                return;
            }
            this.response.setHeader("Last-Modified", Dates.toRfc1123(lastModified));
        }
        int code = payload.code();
        String contentType = payload.rawContentType();
        Object content = payload.rawContent();
        if (content == null) {
            this.response.setStatus(code);
            this.response.setContentLength(0L);
            return;
        }
        String uri = this.request.uri();
        String contentTypeHeader = contentType != null ? contentType : this.getContentType(content, uri);
        this.response.setHeader("Content-Type", contentTypeHeader);
        this.response.setStatus(code);
        if ("HEAD".equals(this.request.method()) || code == 204 || code == 304 || code >= 100 && code < 200) {
            return;
        }
        if (this.isStream(content)) {
            this.streamPayload(uri, payload);
        } else {
            this.writeBytes(uri, payload);
        }
    }

    protected void writeBytes(String uri, Payload payload) throws IOException {
        String previousEtag;
        DataSupplier lazyData = DataSupplier.cache(() -> this.getData(payload.rawContent(), uri));
        String etag = payload.headers().get("ETag");
        if (etag == null) {
            etag = this.etag(lazyData.get());
        }
        if (etag.equals(previousEtag = Strings.stripQuotes(this.request.header("If-None-Match")))) {
            this.response.setStatus(304);
            return;
        }
        this.response.setHeader("ETag", etag);
        byte[] data = lazyData.get();
        this.write(data);
    }

    protected void writeStreamingHeaders() throws IOException {
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setHeader("Connection", "keep-alive");
    }

    protected void streamPayload(String uri, Payload payload) throws IOException {
        this.writeStreamingHeaders();
        if (payload.rawContent() instanceof Stream) {
            this.writeEventStream(payload);
        } else if (payload.rawContent() instanceof BufferedReader) {
            this.writeBufferedReader(payload);
        } else if (payload.rawContent() instanceof InputStream) {
            this.writeInputStream(payload);
        } else if (payload.rawContent() instanceof StreamingOutput) {
            this.writeStreamingOutput(payload);
        }
    }

    protected void writeEventStream(Payload payload) throws IOException {
        PrintStream printStream = new PrintStream(this.response.outputStream());
        try (Stream stream = (Stream)payload.rawContent();){
            stream.forEach(item -> {
                String jsonOrPlainString = item instanceof String ? (String)item : TypeConvert.toJson(item);
                printStream.append("data: ").append(jsonOrPlainString.replaceAll("[\n]", "\ndata: ")).append("\n\n").flush();
            });
        }
    }

    protected void writeBufferedReader(Payload payload) throws IOException {
        BufferedReader lines = (BufferedReader)payload.rawContent();
        this.writeStreamingOutput((OutputStream output) -> {
            try (PrintStream printStream = new PrintStream(output, true);){
                String line;
                while (null != (line = lines.readLine())) {
                    printStream.println(line);
                }
            }
        });
    }

    protected void writeInputStream(Payload payload) throws IOException {
        InputStream stream = (InputStream)payload.rawContent();
        this.writeStreamingOutput((OutputStream output) -> InputStreams.copy(stream, output));
    }

    protected void writeStreamingOutput(Payload payload) throws IOException {
        StreamingOutput stream = (StreamingOutput)payload.rawContent();
        this.writeStreamingOutput(stream);
    }

    protected void writeStreamingOutput(StreamingOutput stream) throws IOException {
        block4: {
            try {
                if (this.shouldGzip()) {
                    this.response.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gzip = new GZIPOutputStream(this.response.outputStream());
                    stream.write(gzip);
                    gzip.finish();
                } else {
                    stream.write(this.response.outputStream());
                }
            }
            catch (IOException e) {
                if (this.shouldIgnoreError(e)) break block4;
                throw e;
            }
        }
    }

    protected void write(byte[] data) throws IOException {
        block4: {
            try {
                if (this.shouldGzip()) {
                    this.response.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gzip = new GZIPOutputStream(this.response.outputStream());
                    gzip.write(data);
                    gzip.finish();
                } else {
                    this.response.setContentLength(data.length);
                    this.response.outputStream().write(data);
                }
            }
            catch (IOException e) {
                if (this.shouldIgnoreError(e)) break block4;
                throw e;
            }
        }
    }

    protected boolean shouldGzip() {
        return this.env.gzip() && this.env.prodMode() && this.request.header("Accept-Encoding", "").contains("gzip");
    }

    protected boolean shouldIgnoreError(IOException e) {
        String message;
        Throwable cause = e.getCause();
        return cause != null && (message = cause.getMessage()) != null && (message.contains("Connection reset by peer") || message.contains("Broken pipe"));
    }

    protected String etag(byte[] data) {
        return Md5.of(data);
    }

    protected boolean isStream(Object content) {
        return content instanceof Stream || content instanceof BufferedReader || content instanceof InputStream || content instanceof StreamingOutput;
    }

    protected String getContentType(Object content, String uri) {
        if (content instanceof File) {
            File file = (File)content;
            return ContentTypes.get(file.getName());
        }
        if (content instanceof Path) {
            Path path = (Path)content;
            return ContentTypes.get(path.toString());
        }
        if (content instanceof SourceFile) {
            SourceFile sourceFile = (SourceFile)content;
            return ContentTypes.get(sourceFile.getPath().toString());
        }
        if (content instanceof URL) {
            return ContentTypes.get(((URL)content).getFile());
        }
        if (content instanceof String || content instanceof CacheEntry) {
            return "text/html;charset=UTF-8";
        }
        if (content instanceof BufferedReader) {
            return "text/plain;charset=UTF-8";
        }
        if (content instanceof byte[] || content instanceof InputStream || content instanceof StreamingOutput) {
            return "application/octet-stream";
        }
        if (content instanceof Stream) {
            return "text/event-stream;charset=UTF-8";
        }
        if (content instanceof ModelAndView) {
            Path path = this.resources.findExistingPath(((ModelAndView)content).view());
            Objects.requireNonNull(path, "View not found for " + uri);
            return ContentTypes.get(path.toString());
        }
        if (content instanceof Model) {
            Path path = this.resources.findExistingPath(uri);
            Objects.requireNonNull(path, "View not found for " + uri);
            return ContentTypes.get(path.toString());
        }
        return "application/json;charset=UTF-8";
    }

    protected byte[] getData(Object content, String uri) throws IOException {
        if (content == null) {
            return null;
        }
        if (content instanceof File) {
            return this.forPath(((File)content).toPath());
        }
        if (content instanceof Path) {
            return this.forPath((Path)content);
        }
        if (content instanceof SourceFile) {
            return this.forSourceFile((SourceFile)content);
        }
        if (content instanceof URL) {
            return this.forURL((URL)content);
        }
        if (content instanceof byte[]) {
            return (byte[])content;
        }
        if (content instanceof String) {
            return this.forString((String)content);
        }
        if (content instanceof CacheEntry) {
            return ((CacheEntry)content).toBytes();
        }
        if (content instanceof ModelAndView) {
            return this.forModelAndView((ModelAndView)content);
        }
        if (content instanceof Model) {
            return this.forModelAndView(ModelAndView.of(uri, (Model)content));
        }
        return this.toJson(content);
    }

    protected byte[] toJson(Object content) {
        return TypeConvert.toByteArray(content);
    }

    protected long getLastModified(Payload payload) throws IOException {
        String lastModified = payload.headers().get("Last-Modified");
        if (lastModified != null) {
            return Dates.parseRfc1123(lastModified);
        }
        Object content = payload.rawContent();
        if (content instanceof File) {
            return this.resources.lastModified(((File)content).toPath());
        }
        if (content instanceof Path) {
            return this.resources.lastModified((Path)content);
        }
        return -1L;
    }

    protected byte[] forString(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    protected byte[] forModelAndView(ModelAndView modelAndView) {
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        keyValues.putAll(modelAndView.model().keyValues());
        keyValues.put("cookies", this.request.cookies().keyValues());
        keyValues.put("env", this.env);
        keyValues.put("site", this.site);
        keyValues.put("request", this.request);
        keyValues.put("response", this.response);
        String body = this.compilers.renderView(modelAndView.view(), keyValues);
        return this.forString(body);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] forURL(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            byte[] byArray = InputStreams.readBytes(stream);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read url:" + url, e);
        }
    }

    protected byte[] forPath(Path path) throws IOException {
        if (this.compilers.supportsTemplating(path)) {
            return this.forTemplatePath(path);
        }
        return this.resources.readBytes(path);
    }

    protected byte[] forSourceFile(SourceFile sourceFile) throws IOException {
        Path path = sourceFile.getPath();
        if (this.compilers.supportsTemplating(path)) {
            return this.forTemplatePath(path);
        }
        return this.compilers.compile(sourceFile).toBytes();
    }

    protected byte[] forTemplatePath(Path path) {
        return this.forModelAndView(ModelAndView.of(Resources.toUnixString(path)));
    }

    protected Payload errorPage(Throwable e) {
        int code = 500;
        if (e instanceof HttpException) {
            code = ((HttpException)e).code();
        } else if (e instanceof NoSuchElementException) {
            code = 404;
        }
        return this.errorPage(code, e);
    }

    protected Payload errorPage(int errorCode, Throwable e) {
        if ("text/html".equals(this.request.header("Accept", "text/html"))) {
            return this.errorPageHtml(errorCode, e);
        }
        return this.errorAsJson(errorCode, e);
    }

    protected Payload errorPageHtml(int errorCode, Throwable e) {
        Throwable shownError = this.env.prodMode() ? null : e;
        return new ErrorPage(errorCode, shownError).payload();
    }

    protected Payload errorAsJson(int errorCode, Throwable e) {
        return new Payload("application/json;charset=UTF-8", new ErrorPayload(e), errorCode);
    }
}

