/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.compilers.CompilersConfiguration;
import net.codestory.http.compilers.SourceFile;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.markdown.MarkdownCompiler;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.TemplatingEngine;
import net.codestory.http.templating.ViewCompiler;

public class CompilerFacade
implements CompilersConfiguration {
    protected final Resources resources;
    protected final Supplier<Compilers> compilers;
    protected final Supplier<TemplatingEngine> templatingEngine;
    protected final Supplier<ViewCompiler> viewCompiler;
    protected final Supplier<MarkdownCompiler> markdownCompiler;

    public CompilerFacade(Env env, Resources resources) {
        this.resources = resources;
        this.compilers = MemoizingSupplier.memoize(() -> this.createCompilers(env, resources));
        this.templatingEngine = MemoizingSupplier.memoize(() -> this.createHandlebarsCompiler(env, resources));
        this.viewCompiler = MemoizingSupplier.memoize(() -> this.createViewCompiler(resources));
        this.markdownCompiler = MemoizingSupplier.memoize(() -> this.createMarkdownCompiler());
    }

    private Compilers createCompilers(Env env, Resources resources) {
        return new Compilers(env, resources);
    }

    private HandlebarsCompiler createHandlebarsCompiler(Env env, Resources resources) {
        return new HandlebarsCompiler(env, resources, this, this.markdownCompiler.get());
    }

    private ViewCompiler createViewCompiler(Resources resources) {
        return new ViewCompiler(resources, this.templatingEngine.get(), this.markdownCompiler.get());
    }

    private MarkdownCompiler createMarkdownCompiler() {
        return new MarkdownCompiler();
    }

    @Override
    public void registerCompiler(Supplier<Compiler> compilerFactory, String compiledExtension, String sourceExtension) {
        this.compilers.get().register(compilerFactory, compiledExtension, sourceExtension);
    }

    @Override
    public void configureHandlebars(Consumer<Handlebars> action) {
        ((HandlebarsCompiler)this.templatingEngine.get()).configure(action);
    }

    @Override
    public void addHandlebarsResolver(ValueResolver resolver) {
        ((HandlebarsCompiler)this.templatingEngine.get()).addResolver(resolver);
    }

    public boolean canCompile(String extension) {
        return this.compilers.get().canCompile(extension);
    }

    public Set<String> extensionsThatCompileTo(String extension) {
        return this.compilers.get().extensionsThatCompileTo(extension);
    }

    public String compiledExtension(String extension) {
        return this.compilers.get().compiledExtension(extension);
    }

    public CacheEntry compile(Path path) throws IOException {
        return this.compilers.get().compile(this.resources.sourceFile(path));
    }

    public CacheEntry compile(SourceFile sourceFile) {
        return this.compilers.get().compile(sourceFile);
    }

    public String renderView(String uri, Map<String, ?> variables) {
        return this.viewCompiler.get().render(uri, variables);
    }

    public boolean supportsTemplating(Path path) {
        return this.templatingEngine.get().supports(path);
    }

    public Path findPublicSourceFor(String uri) {
        String extension = Strings.extension(uri);
        for (String sourceExtension : this.extensionsThatCompileTo(extension)) {
            Path sourcePath = Paths.get(Strings.replaceLast(uri, extension, sourceExtension), new String[0]);
            if (!this.resources.isPublic(sourcePath)) continue;
            return sourcePath;
        }
        return null;
    }
}

