/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.payload;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.codestory.http.Cookie;
import net.codestory.http.NewCookie;
import net.codestory.http.convert.TypeConvert;

public class Payload {
    private final String contentType;
    private final Object content;
    private final Map<String, String> headers;
    private final List<Cookie> cookies;
    private int code;

    public Payload(Object content) {
        this(null, content);
    }

    public Payload(String contentType, Object content) {
        this(contentType, content, 200);
    }

    public Payload(int code) {
        this(null, null, code);
    }

    public Payload(String contentType, Object content, int code) {
        if (content instanceof Payload) {
            Payload wrapped = (Payload)content;
            this.contentType = null == contentType ? wrapped.contentType : contentType;
            this.content = wrapped.content;
            this.code = wrapped.code;
            this.headers = new LinkedHashMap<String, String>(wrapped.headers);
            this.cookies = new ArrayList<Cookie>(wrapped.cookies);
            return;
        }
        if (content instanceof Optional) {
            Optional optional = (Optional)content;
            if (optional.isPresent()) {
                this.content = optional.get();
                this.code = code;
            } else {
                this.content = null;
                this.code = 404;
            }
        } else {
            this.content = content;
            this.code = code;
        }
        this.contentType = contentType;
        this.headers = new LinkedHashMap<String, String>();
        this.cookies = new ArrayList<Cookie>();
    }

    public Payload withMaxAge(int maxAge) {
        return this.withHeader("Access-Control-Max-Age", Integer.toString(maxAge));
    }

    public Payload withAllowCredentials(boolean allowedCredentials) {
        return this.withHeader("Access-Control-Allow-Credentials", Boolean.toString(allowedCredentials));
    }

    public Payload withAllowOrigin(String allowedOrigin) {
        return this.withHeader("Access-Control-Allow-Origin", allowedOrigin);
    }

    public Payload withAllowMethods(String ... allowedMethods) {
        return this.withHeader("Access-Control-Allow-Methods", String.join((CharSequence)", ", allowedMethods));
    }

    public Payload withAllowHeaders(String ... allowedHeaders) {
        return this.withHeader("Access-Control-Allow-Headers", String.join((CharSequence)", ", allowedHeaders));
    }

    public Payload withExposeHeaders(String ... allowedHeaders) {
        return this.withHeader("Access-Control-Expose-Headers", String.join((CharSequence)", ", allowedHeaders));
    }

    public Payload withHeader(String key, String value) {
        if (value != null) {
            this.headers.put(key, value);
        }
        return this;
    }

    public Payload withHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public Payload withCookie(String name, int value) {
        return this.withCookie(name, Integer.toString(value));
    }

    public Payload withCookie(String name, long value) {
        return this.withCookie(name, Long.toString(value));
    }

    public Payload withCookie(String name, boolean value) {
        return this.withCookie(name, Boolean.toString(value));
    }

    public Payload withCookie(String name, String value) {
        return this.withCookie(new NewCookie(name, value, "/", true));
    }

    public Payload withCookie(String name, Object value) {
        return this.withCookie(name, TypeConvert.toJson(value));
    }

    public Payload withCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public Payload withCookies(List<Cookie> cookieList) {
        this.cookies.addAll(cookieList);
        return this;
    }

    public Payload withCode(int code) {
        this.code = code;
        return this;
    }

    public String rawContentType() {
        return this.contentType;
    }

    public Object rawContent() {
        return this.content;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    public int code() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.code >= 200 && this.code <= 299;
    }

    public boolean isError() {
        return this.code >= 400 && this.code <= 599;
    }

    public static Payload ok() {
        return new Payload(200);
    }

    public static Payload created() {
        return new Payload(201);
    }

    public static Payload created(String uri) {
        return new Payload(201).withHeader("Location", uri);
    }

    public static Payload movedPermanently(String uri) {
        return new Payload(301).withHeader("Location", uri);
    }

    public static Payload seeOther(String uri) {
        return new Payload(303).withHeader("Location", uri);
    }

    public static Payload seeOther(URI uri) {
        return Payload.seeOther(uri.toString());
    }

    public static Payload temporaryRedirect(String uri) {
        return new Payload(307).withHeader("Location", uri);
    }

    public static Payload temporaryRedirect(URI uri) {
        return Payload.temporaryRedirect(uri.toString());
    }

    public static Payload notModified() {
        return new Payload(304);
    }

    public static Payload unauthorized(String realm) {
        return new Payload(401).withHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
    }

    public static Payload forbidden() {
        return new Payload(403);
    }

    public static Payload notFound() {
        return new Payload(404);
    }

    public static Payload methodNotAllowed() {
        return new Payload(405);
    }

    public static Payload badRequest() {
        return new Payload(400);
    }
}

