/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.compilers.CacheEntry;
import net.codestory.http.compilers.Compilers;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class SourceMapRoute
implements Route {
    SourceMapRoute() {
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".map") && Resources.isPublic(SourceMapRoute.pathSource(uri));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Payload body(Context context) throws IOException {
        String uri = context.uri();
        Path pathLess = SourceMapRoute.pathSource(uri);
        Path pathMap = Paths.get(uri, new String[0]);
        String contentType = ContentTypes.get(pathMap);
        String less = Resources.read(pathLess, StandardCharsets.UTF_8);
        CacheEntry map = Compilers.INSTANCE.compile(pathMap, less);
        return new Payload(contentType, map);
    }

    private static Path pathSource(String uri) {
        if (uri.endsWith(".css.map")) {
            return Paths.get(Strings.substringBeforeLast(uri, ".css.map") + ".less", new String[0]);
        }
        return Paths.get(Strings.substringBeforeLast(uri, ".map"), new String[0]);
    }
}

