/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Context;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.routes.Route;

public class SourceRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private final CompilerFacade compilers;

    SourceRoute(CompilerFacade compilers) {
        this.compilers = compilers;
    }

    @Override
    public boolean matchUri(String uri) {
        return uri.endsWith(".source") && Resources.isPublic(this.findPath(uri, SourceRoute.getSourcePath(uri)));
    }

    @Override
    public boolean matchMethod(String method) {
        return "GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method);
    }

    @Override
    public Object body(Context context) {
        String sourceUri = SourceRoute.getSourcePath(context.uri());
        return this.findPath(context.uri(), sourceUri);
    }

    public Path findPath(String uri, String sourceUri) {
        Path sourcePath = Resources.findExistingPath(sourceUri);
        if (sourcePath != null && Resources.isPublic(sourcePath)) {
            return sourcePath;
        }
        String extension = Strings.extension(sourceUri);
        for (String sourceExtension : this.compilers.extensionsThatCompileTo(extension)) {
            sourcePath = Paths.get(SourceRoute.getSourcePath(Strings.replaceLast(uri, extension, sourceExtension)), new String[0]);
            if (!Resources.isPublic(sourcePath)) continue;
            return sourcePath;
        }
        return NOT_FOUND;
    }

    private static String getSourcePath(String uri) {
        return Strings.substringBeforeLast(uri, ".source");
    }
}

