/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Supplier;
import net.codestory.http.Configuration;
import net.codestory.http.Context;
import net.codestory.http.Request;
import net.codestory.http.Response;
import net.codestory.http.annotations.AnnotationHelper;
import net.codestory.http.compilers.CompilerFacade;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.extensions.Extensions;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.injection.Singletons;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.payload.PayloadWriter;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.CatchAllRoute;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.NoParamRouteWithContext;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWrapper;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.RoutesWithPattern;
import net.codestory.http.routes.SourceMapRoute;
import net.codestory.http.routes.SourceRoute;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.TwoParamsRoute;
import net.codestory.http.routes.UriParser;
import net.codestory.http.routes.WebJarsRoute;
import net.codestory.http.templating.Site;

public class RouteCollection
implements Routes {
    protected final Env env;
    protected final CompilerFacade compilers;
    protected final Site site;
    protected final Deque<Route> routes;
    protected final Deque<Supplier<Filter>> filters;
    protected IocAdapter iocAdapter;
    protected Extensions extensions;

    public RouteCollection(Env env) {
        this.env = env;
        this.compilers = new CompilerFacade(env);
        this.site = new Site(env);
        this.routes = new LinkedList<Route>();
        this.filters = new LinkedList<Supplier<Filter>>();
        this.iocAdapter = new Singletons(new Object[0]);
        this.extensions = Extensions.DEFAULT;
    }

    public void configure(Configuration configuration) {
        configuration.configure(this);
        this.installExtensions();
        this.addStaticRoutes(this.env.prodMode());
    }

    private void installExtensions() {
        TypeConvert.configureOrReplaceMapper(mapper -> this.extensions.configureOrReplaceObjectMapper((ObjectMapper)mapper, this.env));
        this.extensions.configureCompilers(this.compilers, this.env);
    }

    private void addStaticRoutes(boolean prodMode) {
        this.routes.add(new WebJarsRoute(prodMode));
        this.routes.add(new StaticRoute(prodMode, this.compilers));
        if (!prodMode) {
            this.routes.add(new SourceMapRoute());
            this.routes.add(new SourceRoute(this.compilers));
        }
    }

    public PayloadWriter createPayloadWriter(Request request, Response response) {
        return this.extensions.createPayloadWriter(request, response, this.env, this.site, this.compilers);
    }

    public Context createContext(Request request, Response response) {
        return this.extensions.createContext(request, response, this.iocAdapter, this.site);
    }

    @Override
    public RouteCollection setExtensions(Extensions extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    public RouteCollection setIocAdapter(IocAdapter iocAdapter) {
        this.iocAdapter = iocAdapter;
        return this;
    }

    @Override
    public RouteCollection include(Class<? extends Configuration> configurationClass) {
        this.iocAdapter.get(configurationClass).configure(this);
        return this;
    }

    @Override
    public RouteCollection include(Configuration configuration) {
        configuration.configure(this);
        return this;
    }

    @Override
    public RouteCollection filter(Class<? extends Filter> filterClass) {
        this.filters.addFirst(() -> (Filter)this.iocAdapter.get(filterClass));
        return this;
    }

    @Override
    public RouteCollection filter(Filter filter) {
        this.filters.addFirst(() -> filter);
        return this;
    }

    @Override
    public RouteCollection add(Class<?> resourceType) {
        this.addResource("", resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Class<?> resourceType) {
        this.addResource(urlPrefix, resourceType, () -> this.iocAdapter.get(resourceType));
        return this;
    }

    @Override
    public RouteCollection add(Object resource) {
        this.addResource("", resource.getClass(), () -> resource);
        return this;
    }

    @Override
    public RouteCollection add(String urlPrefix, Object resource) {
        this.addResource(urlPrefix, resource.getClass(), () -> resource);
        return this;
    }

    protected void addResource(String urlPrefix, Class<?> type, Supplier<Object> resource) {
        AnnotationHelper.parseAnnotations(urlPrefix, type, (httpMethod, uri, method) -> this.addResource(httpMethod, method, resource, uri));
    }

    protected void addResource(String httpMethod, Method method, Supplier<Object> resource, String uriPattern) {
        int uriParamsCount;
        int methodParamsCount = method.getParameterCount();
        if (methodParamsCount < (uriParamsCount = UriParser.paramsCount(uriPattern))) {
            throw new IllegalArgumentException("Expected at least" + uriParamsCount + " parameters in " + uriPattern);
        }
        this.add(httpMethod, uriPattern, new ReflectionRoute(resource, method));
    }

    @Override
    public RouteCollection get(String uriPattern, Object payload) {
        this.get(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, NoParamRouteWithContext route) {
        this.add("GET", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, OneParamRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection get(String uriPattern, FourParamsRoute route) {
        this.add("GET", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, Object payload) {
        this.options(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, NoParamRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, NoParamRouteWithContext route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, OneParamRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, TwoParamsRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, ThreeParamsRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection options(String uriPattern, FourParamsRoute route) {
        this.add("OPTIONS", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, Object payload) {
        this.head(uriPattern, () -> payload);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, NoParamRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, NoParamRouteWithContext route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, OneParamRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, TwoParamsRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, ThreeParamsRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection head(String uriPattern, FourParamsRoute route) {
        this.add("HEAD", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, NoParamRouteWithContext route) {
        this.add("POST", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, OneParamRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection post(String uriPattern, FourParamsRoute route) {
        this.add("POST", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, NoParamRouteWithContext route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, OneParamRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, TwoParamsRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, ThreeParamsRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection put(String uriPattern, FourParamsRoute route) {
        this.add("PUT", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, NoParamRouteWithContext route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 0), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, OneParamRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 1), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, TwoParamsRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 2), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, ThreeParamsRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 3), route);
        return this;
    }

    @Override
    public RouteCollection delete(String uriPattern, FourParamsRoute route) {
        this.add("DELETE", this.checkParametersCount(uriPattern, 4), route);
        return this;
    }

    @Override
    public RouteCollection catchAll(Object payload) {
        this.catchAll(() -> payload);
        return this;
    }

    @Override
    public RouteCollection catchAll(NoParamRoute route) {
        this.routes.add(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RouteCollection catchAll(NoParamRouteWithContext route) {
        this.routes.add(new CatchAllRoute(route));
        return this;
    }

    @Override
    public RoutesWithPattern with(String uriPattern) {
        return new RoutesWithPattern(this, uriPattern);
    }

    protected RouteCollection add(String method, String uriPattern, AnyRoute route) {
        this.routes.add(new RouteWrapper(method, uriPattern, route));
        return this;
    }

    public Payload apply(Context context) throws IOException {
        String uri = context.uri();
        if (uri == null) {
            return Payload.notFound();
        }
        PayloadSupplier payloadSupplier = () -> {
            Payload response = Payload.notFound();
            for (Route route : this.routes) {
                if (route.matchUri(uri)) {
                    if (route.matchMethod(context.method())) {
                        return route.apply(uri, context);
                    }
                    response = Payload.methodNotAllowed();
                    continue;
                }
                if (uri.endsWith("/") || !route.matchUri(uri + '/')) continue;
                if (route.matchMethod(context.method())) {
                    return Payload.seeOther(uri + '/');
                }
                response = Payload.methodNotAllowed();
            }
            return response;
        };
        for (Supplier<Filter> filter : this.filters) {
            if (!filter.get().matches(uri, context)) continue;
            PayloadSupplier nextFilter = payloadSupplier;
            payloadSupplier = () -> ((Filter)filter.get()).apply(uri, context, nextFilter);
        }
        return payloadSupplier.get();
    }

    protected String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            String error = count == 1 ? "1 parameter" : count + " parameters";
            throw new IllegalArgumentException("Expected " + error + " in " + uriPattern);
        }
        return uriPattern;
    }
}

