/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import net.codestory.http.internal.Handler;
import net.codestory.http.internal.HttpServerWrapper;
import net.codestory.http.internal.SimpleRequest;
import net.codestory.http.internal.SimpleResponse;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.SocketConnection;

public class SimpleServerWrapper
implements HttpServerWrapper {
    private final SocketProcessor server = new ContainerSocketProcessor((req, resp) -> handler.handle(new SimpleRequest(req), new SimpleResponse(resp)), 8, 1);

    public SimpleServerWrapper(Handler handler) throws IOException {
    }

    @Override
    public void start(int port, SSLContext context, boolean authReq) throws IOException {
        SocketConnection socketConnection = new SocketConnection((SocketProcessor)(authReq ? new AuthRequiredServer(this.server) : this.server));
        socketConnection.connect((SocketAddress)new InetSocketAddress(port), context);
    }

    @Override
    public void stop() throws IOException {
        this.server.stop();
    }

    private static class AuthRequiredServer
    implements SocketProcessor {
        private final SocketProcessor delegate;

        AuthRequiredServer(SocketProcessor delegate) {
            this.delegate = delegate;
        }

        public void process(Socket socket) throws IOException {
            socket.getEngine().setNeedClientAuth(true);
            this.delegate.process(socket);
        }

        public void stop() throws IOException {
            this.delegate.stop();
        }
    }
}

