/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class InputStreams {
    private static final int BUF_SIZE = 4096;

    private InputStreams() {
    }

    public static byte[] readBytes(InputStream from) throws IOException {
        return InputStreams.read(from, ByteArrayOutputStream::toByteArray);
    }

    public static String readString(InputStream from, Charset charset) throws IOException {
        return InputStreams.read(from, byteArrayOutputStream -> byteArrayOutputStream.toString(charset.name()));
    }

    public static <T> T read(InputStream from, ForBytes<T> transform) throws IOException {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            int count;
            byte[] buffer = new byte[4096];
            while (-1 != (count = from.read(buffer))) {
                bytes.write(buffer, 0, count);
            }
            T t = transform.apply(bytes);
            return t;
        }
    }

    @FunctionalInterface
    private static interface ForBytes<T> {
        public T apply(ByteArrayOutputStream var1) throws IOException;
    }
}

