/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.codestory.http.internal.Context;

public class TypeConvert {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);

    private TypeConvert() {
    }

    public static Object[] convert(Context context, String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length + 1];
        converted[0] = TypeConvert.convert(context, types[0]);
        for (int i = 0; i < values.length; ++i) {
            converted[i + 1] = TypeConvert.convert(values[i], types[i]);
        }
        return converted;
    }

    public static Object[] convert(String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = TypeConvert.convert(values[i], types[i]);
        }
        return converted;
    }

    public static Object convert(Context context, Class<?> type) {
        if (type.isAssignableFrom(Context.class)) {
            return context;
        }
        if (type.isAssignableFrom(Map.class)) {
            return context.getKeyValues();
        }
        return TypeConvert.convert(context.getKeyValues(), type);
    }

    public static <T> T convert(String value, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue((Object)value, type);
    }

    public static <T> T convert(Map<String, String> keyValues, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue(keyValues, type);
    }

    public static byte[] toByteArray(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writer().writeValueAsBytes(value);
    }
}

